/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;

public class SqlPagingQueryUtils {
    public static String generateLimitSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String limitClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        sql.append(" ORDER BY ").append(provider.getSortKeyWithoutAlias());
        SqlPagingQueryUtils.buildAscendingClause(provider, sql);
        sql.append(" " + limitClause);
        return sql.toString();
    }

    public static String generateTopSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String topClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(topClause).append(" ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        sql.append(" ORDER BY ").append(provider.getSortKeyWithoutAlias());
        SqlPagingQueryUtils.buildAscendingClause(provider, sql);
        return sql.toString();
    }

    public static String generateRowNumSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String rowNumClause) {
        return SqlPagingQueryUtils.generateRowNumSqlQuery(provider, provider.getSelectClause(), remainingPageQuery, rowNumClause);
    }

    public static String generateRowNumSqlQuery(AbstractSqlPagingQueryProvider provider, String selectClause, boolean remainingPageQuery, String rowNumClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM (SELECT ").append(selectClause).append(", ROWNUM as TMP_ROW_NUM");
        sql.append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        sql.append(" ORDER BY ").append(provider.getSortKeyWithoutAlias());
        SqlPagingQueryUtils.buildAscendingClause(provider, sql);
        sql.append(") WHERE ").append(rowNumClause);
        return sql.toString();
    }

    public static String generateRowNumSqlQueryWithNesting(AbstractSqlPagingQueryProvider provider, String selectClause, boolean remainingPageQuery, String rowNumClause) {
        return SqlPagingQueryUtils.generateRowNumSqlQueryWithNesting(provider, selectClause, selectClause, remainingPageQuery, rowNumClause);
    }

    public static String generateRowNumSqlQueryWithNesting(AbstractSqlPagingQueryProvider provider, String innerSelectClause, String outerSelectClause, boolean remainingPageQuery, String rowNumClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(outerSelectClause).append(" FROM (SELECT ").append(outerSelectClause).append(", ROWNUM as TMP_ROW_NUM");
        sql.append(" FROM (SELECT ").append(innerSelectClause).append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        sql.append(" ORDER BY ").append(provider.getSortKeyWithoutAlias());
        SqlPagingQueryUtils.buildAscendingClause(provider, sql);
        sql.append(")) WHERE ").append(rowNumClause);
        return sql.toString();
    }

    public static String generateLimitJumpToQuery(AbstractSqlPagingQueryProvider provider, String limitClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(provider.getSortKey()).append(" AS SORT_KEY");
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        sql.append(" ORDER BY ").append(provider.getSortKeyWithoutAlias());
        SqlPagingQueryUtils.buildAscendingClause(provider, sql);
        sql.append(" " + limitClause);
        return sql.toString();
    }

    public static String generateTopJumpToQuery(AbstractSqlPagingQueryProvider provider, String topClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(topClause).append(" ").append(provider.getSortKey()).append(" AS SORT_KEY");
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        sql.append(" ORDER BY ").append(provider.getSortKeyWithoutAlias());
        SqlPagingQueryUtils.buildAscendingClause(provider, sql);
        return sql.toString();
    }

    private static void buildAscendingClause(AbstractSqlPagingQueryProvider provider, StringBuilder sql) {
        if (provider.isAscending()) {
            sql.append(" ASC");
        } else {
            sql.append(" DESC");
        }
    }

    private static void buildWhereClause(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, StringBuilder sql) {
        if (remainingPageQuery) {
            sql.append(" WHERE ");
            if (provider.getWhereClause() != null) {
                sql.append(provider.getWhereClause());
                sql.append(" AND ");
            }
            sql.append(provider.getSortKey());
            if (provider.isAscending()) {
                sql.append(" > ");
            } else {
                sql.append(" < ");
            }
            sql.append(provider.getSortKeyPlaceHolder());
        } else {
            sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        }
    }
}

