/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.SqliteMaxValueIncrementer;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.support.incrementer.DB2MainframeSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DB2SequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DerbyMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.H2SequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.HsqlMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SqlServerMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SybaseMaxValueIncrementer;
import org.springframework.util.ReflectionUtils;

public class DefaultDataFieldMaxValueIncrementerFactory
implements DataFieldMaxValueIncrementerFactory {
    private DataSource dataSource;
    private String incrementerColumnName = "ID";

    public void setIncrementerColumnName(String incrementerColumnName) {
        this.incrementerColumnName = incrementerColumnName;
    }

    public DefaultDataFieldMaxValueIncrementerFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public DataFieldMaxValueIncrementer getIncrementer(String incrementerType, String incrementerName) {
        DatabaseType databaseType = DatabaseType.valueOf(incrementerType.toUpperCase());
        if (databaseType == DatabaseType.DB2 || databaseType == DatabaseType.DB2AS400) {
            return new DB2SequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.DB2ZOS) {
            return new DB2MainframeSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.DERBY) {
            return new DerbyMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.HSQL) {
            return new HsqlMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.H2) {
            return new H2SequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.MYSQL) {
            MySQLMaxValueIncrementer incr = new MySQLMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
            Method m = ReflectionUtils.findMethod(incr.getClass(), (String)"setUseNewConnection", (Class[])new Class[]{Boolean.TYPE});
            if (m != null) {
                ReflectionUtils.makeAccessible((Method)m);
                ReflectionUtils.invokeMethod((Method)m, (Object)incr, (Object[])new Object[]{true});
            }
            return incr;
        }
        if (databaseType == DatabaseType.ORACLE) {
            return new OracleSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.POSTGRES) {
            return new PostgreSQLSequenceMaxValueIncrementer(this.dataSource, incrementerName);
        }
        if (databaseType == DatabaseType.SQLITE) {
            return new SqliteMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.SQLSERVER) {
            return new SqlServerMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        if (databaseType == DatabaseType.SYBASE) {
            return new SybaseMaxValueIncrementer(this.dataSource, incrementerName, this.incrementerColumnName);
        }
        throw new IllegalArgumentException("databaseType argument was not on the approved list");
    }

    @Override
    public boolean isSupportedIncrementerType(String incrementerType) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!type.name().equals(incrementerType.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSupportedIncrementerTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (DatabaseType type : DatabaseType.values()) {
            types.add(type.name());
        }
        return types.toArray(new String[types.size()]);
    }
}

