/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.util.Assert;

public class RegexLineTokenizer
extends AbstractLineTokenizer {
    private Pattern pattern;

    @Override
    protected List<String> doTokenize(String line) {
        Matcher matcher = this.pattern.matcher(line);
        boolean matchFound = matcher.find();
        if (matchFound) {
            ArrayList<String> tokens = new ArrayList<String>(matcher.groupCount());
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                tokens.add(matcher.group(i));
            }
            return tokens;
        }
        return Collections.emptyList();
    }

    public void setPattern(Pattern pattern) {
        Assert.notNull((Object)pattern, (String)"a non-null pattern is required");
        this.pattern = pattern;
    }

    public void setRegex(String regex) {
        Assert.hasText((String)regex, (String)"a valid regex is required");
        this.pattern = Pattern.compile(regex);
    }
}

