/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;

public class ExecutionContext
implements Serializable {
    private volatile boolean dirty = false;
    private final Map<String, Object> map;

    public ExecutionContext() {
        this.map = new ConcurrentHashMap<String, Object>();
    }

    public ExecutionContext(Map<String, Object> map) {
        this.map = new ConcurrentHashMap<String, Object>(map);
    }

    public ExecutionContext(ExecutionContext executionContext) {
        this();
        if (executionContext == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : executionContext.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public void putString(String key, @Nullable String value) {
        this.put(key, value);
    }

    public void putLong(String key, long value) {
        this.put(key, value);
    }

    public void putInt(String key, int value) {
        this.put(key, value);
    }

    public void putDouble(String key, double value) {
        this.put(key, value);
    }

    public void put(String key, @Nullable Object value) {
        Object result;
        this.dirty = value != null ? (result = this.map.put(key, value)) == null || result != null && !result.equals(value) : (result = this.map.remove(key)) != null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getString(String key) {
        return (String)this.readAndValidate(key, String.class);
    }

    public String getString(String key, String defaultString) {
        if (!this.containsKey(key)) {
            return defaultString;
        }
        return this.getString(key);
    }

    public long getLong(String key) {
        return (Long)this.readAndValidate(key, Long.class);
    }

    public long getLong(String key, long defaultLong) {
        if (!this.containsKey(key)) {
            return defaultLong;
        }
        return this.getLong(key);
    }

    public int getInt(String key) {
        return (Integer)this.readAndValidate(key, Integer.class);
    }

    public int getInt(String key, int defaultInt) {
        if (!this.containsKey(key)) {
            return defaultInt;
        }
        return this.getInt(key);
    }

    public double getDouble(String key) {
        return (Double)this.readAndValidate(key, Double.class);
    }

    public double getDouble(String key, double defaultDouble) {
        if (!this.containsKey(key)) {
            return defaultDouble;
        }
        return this.getDouble(key);
    }

    @Nullable
    public Object get(String key) {
        return this.map.get(key);
    }

    private Object readAndValidate(String key, Class<?> type) {
        Object value = this.get(key);
        if (!type.isInstance(value)) {
            throw new ClassCastException("Value for key=[" + key + "] is not of type: [" + type + "], it is [" + (value == null ? null : "(" + value.getClass() + ")" + value) + "]");
        }
        return value;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Nullable
    public Object remove(String key) {
        return this.map.remove(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExecutionContext rhs = (ExecutionContext)obj;
        return this.entrySet().equals(rhs.entrySet());
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }
}

