/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.BeanWrapperFieldExtractor;
import org.springframework.batch.item.file.transform.DelimitedLineAggregator;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.FormatterLineAggregator;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FlatFileItemWriterBuilder<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Resource resource;
    private boolean forceSync = false;
    private String lineSeparator = FlatFileItemWriter.DEFAULT_LINE_SEPARATOR;
    private LineAggregator<T> lineAggregator;
    private String encoding = "UTF-8";
    private boolean shouldDeleteIfExists = true;
    private boolean append = false;
    private boolean shouldDeleteIfEmpty = false;
    private FlatFileHeaderCallback headerCallback;
    private FlatFileFooterCallback footerCallback;
    private boolean transactional = true;
    private boolean saveState = true;
    private String name;
    private DelimitedBuilder<T> delimitedBuilder;
    private FormattedBuilder<T> formattedBuilder;

    public FlatFileItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public FlatFileItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public FlatFileItemWriterBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public FlatFileItemWriterBuilder<T> forceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public FlatFileItemWriterBuilder<T> lineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public FlatFileItemWriterBuilder<T> lineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
        return this;
    }

    public FlatFileItemWriterBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public FlatFileItemWriterBuilder<T> shouldDeleteIfEmpty(boolean shouldDelete) {
        this.shouldDeleteIfEmpty = shouldDelete;
        return this;
    }

    public FlatFileItemWriterBuilder<T> shouldDeleteIfExists(boolean shouldDelete) {
        this.shouldDeleteIfExists = shouldDelete;
        return this;
    }

    public FlatFileItemWriterBuilder<T> append(boolean append) {
        this.append = append;
        return this;
    }

    public FlatFileItemWriterBuilder<T> headerCallback(FlatFileHeaderCallback callback) {
        this.headerCallback = callback;
        return this;
    }

    public FlatFileItemWriterBuilder<T> footerCallback(FlatFileFooterCallback callback) {
        this.footerCallback = callback;
        return this;
    }

    public FlatFileItemWriterBuilder<T> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public DelimitedBuilder<T> delimited() {
        this.delimitedBuilder = new DelimitedBuilder(this);
        return this.delimitedBuilder;
    }

    public FormattedBuilder<T> formatted() {
        this.formattedBuilder = new FormattedBuilder(this);
        return this.formattedBuilder;
    }

    public FlatFileItemWriter<T> build() {
        Assert.isTrue((this.lineAggregator != null || this.delimitedBuilder != null || this.formattedBuilder != null ? 1 : 0) != 0, (String)"A LineAggregator or a DelimitedBuilder or a FormattedBuilder is required");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is true");
        }
        if (this.resource == null) {
            this.logger.debug((Object)"The resource is null. This is only a valid scenario when injecting it later as in when using the MultiResourceItemWriter");
        }
        FlatFileItemWriter<T> writer = new FlatFileItemWriter<T>();
        writer.setName(this.name);
        writer.setAppendAllowed(this.append);
        writer.setEncoding(this.encoding);
        writer.setFooterCallback(this.footerCallback);
        writer.setForceSync(this.forceSync);
        writer.setHeaderCallback(this.headerCallback);
        if (this.lineAggregator == null) {
            Assert.state((this.delimitedBuilder == null || this.formattedBuilder == null ? 1 : 0) != 0, (String)"Either a DelimitedLineAggregator or a FormatterLineAggregator should be provided, but not both");
            this.lineAggregator = this.delimitedBuilder != null ? this.delimitedBuilder.build() : this.formattedBuilder.build();
        }
        writer.setLineAggregator(this.lineAggregator);
        writer.setLineSeparator(this.lineSeparator);
        writer.setResource(this.resource);
        writer.setSaveState(this.saveState);
        writer.setShouldDeleteIfEmpty(this.shouldDeleteIfEmpty);
        writer.setShouldDeleteIfExists(this.shouldDeleteIfExists);
        writer.setTransactional(this.transactional);
        return writer;
    }

    public static class DelimitedBuilder<T> {
        private FlatFileItemWriterBuilder<T> parent;
        private List<String> names = new ArrayList<String>();
        private String delimiter = ",";
        private FieldExtractor<T> fieldExtractor;

        protected DelimitedBuilder(FlatFileItemWriterBuilder<T> parent) {
            this.parent = parent;
        }

        public DelimitedBuilder<T> delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public FlatFileItemWriterBuilder<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public FlatFileItemWriterBuilder<T> fieldExtractor(FieldExtractor<T> fieldExtractor) {
            this.fieldExtractor = fieldExtractor;
            return this.parent;
        }

        public DelimitedLineAggregator<T> build() {
            Assert.isTrue((this.names != null && !this.names.isEmpty() || this.fieldExtractor != null ? 1 : 0) != 0, (String)"A list of field names or a field extractor is required");
            DelimitedLineAggregator<T> delimitedLineAggregator = new DelimitedLineAggregator<T>();
            if (this.delimiter != null) {
                delimitedLineAggregator.setDelimiter(this.delimiter);
            }
            if (this.fieldExtractor == null) {
                BeanWrapperFieldExtractor beanWrapperFieldExtractor = new BeanWrapperFieldExtractor();
                beanWrapperFieldExtractor.setNames(this.names.toArray(new String[this.names.size()]));
                try {
                    beanWrapperFieldExtractor.afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to initialize DelimitedLineAggregator", e);
                }
                this.fieldExtractor = beanWrapperFieldExtractor;
            }
            delimitedLineAggregator.setFieldExtractor(this.fieldExtractor);
            return delimitedLineAggregator;
        }
    }

    public static class FormattedBuilder<T> {
        private FlatFileItemWriterBuilder<T> parent;
        private String format;
        private Locale locale = Locale.getDefault();
        private int maximumLength = 0;
        private int minimumLength = 0;
        private FieldExtractor<T> fieldExtractor;
        private List<String> names = new ArrayList<String>();

        protected FormattedBuilder(FlatFileItemWriterBuilder<T> parent) {
            this.parent = parent;
        }

        public FormattedBuilder<T> format(String format) {
            this.format = format;
            return this;
        }

        public FormattedBuilder<T> locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public FormattedBuilder<T> minimumLength(int minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public FormattedBuilder<T> maximumLength(int maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public FlatFileItemWriterBuilder<T> fieldExtractor(FieldExtractor<T> fieldExtractor) {
            this.fieldExtractor = fieldExtractor;
            return this.parent;
        }

        public FlatFileItemWriterBuilder<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public FormatterLineAggregator<T> build() {
            Assert.notNull((Object)this.format, (String)"A format is required");
            Assert.isTrue((this.names != null && !this.names.isEmpty() || this.fieldExtractor != null ? 1 : 0) != 0, (String)"A list of field names or a field extractor is required");
            FormatterLineAggregator<T> formatterLineAggregator = new FormatterLineAggregator<T>();
            formatterLineAggregator.setFormat(this.format);
            formatterLineAggregator.setLocale(this.locale);
            formatterLineAggregator.setMinimumLength(this.minimumLength);
            formatterLineAggregator.setMaximumLength(this.maximumLength);
            if (this.fieldExtractor == null) {
                BeanWrapperFieldExtractor beanWrapperFieldExtractor = new BeanWrapperFieldExtractor();
                beanWrapperFieldExtractor.setNames(this.names.toArray(new String[this.names.size()]));
                try {
                    beanWrapperFieldExtractor.afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to initialize FormatterLineAggregator", e);
                }
                this.fieldExtractor = beanWrapperFieldExtractor;
            }
            formatterLineAggregator.setFieldExtractor(this.fieldExtractor);
            return formatterLineAggregator;
        }
    }
}

