/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.batch.item.KeyValueItemWriter;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;

public class KafkaItemWriter<K, T>
extends KeyValueItemWriter<K, T> {
    protected KafkaTemplate<K, T> kafkaTemplate;
    private final List<ListenableFuture<SendResult<K, T>>> listenableFutures = new ArrayList<ListenableFuture<SendResult<K, T>>>();
    private long timeout = -1L;

    @Override
    protected void writeKeyValue(K key, T value) {
        if (this.delete) {
            this.listenableFutures.add(this.kafkaTemplate.sendDefault(key, null));
        } else {
            this.listenableFutures.add(this.kafkaTemplate.sendDefault(key, value));
        }
    }

    @Override
    protected void flush() throws Exception {
        this.kafkaTemplate.flush();
        for (ListenableFuture<SendResult<K, T>> future : this.listenableFutures) {
            if (this.timeout >= 0L) {
                future.get(this.timeout, TimeUnit.MILLISECONDS);
                continue;
            }
            future.get();
        }
        this.listenableFutures.clear();
    }

    @Override
    protected void init() {
        Assert.notNull(this.kafkaTemplate, (String)"KafkaTemplate must not be null.");
        Assert.notNull((Object)this.kafkaTemplate.getDefaultTopic(), (String)"KafkaTemplate must have the default topic set.");
    }

    public void setKafkaTemplate(KafkaTemplate<K, T> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

