/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.data.RepositoryItemReader;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryItemReaderBuilder<T> {
    private PagingAndSortingRepository<?, ?> repository;
    private Map<String, Sort.Direction> sorts;
    private List<?> arguments;
    private int pageSize = 10;
    private String methodName;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public RepositoryItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public RepositoryItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public RepositoryItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public RepositoryItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public RepositoryItemReaderBuilder<T> arguments(List<?> arguments) {
        this.arguments = arguments;
        return this;
    }

    public RepositoryItemReaderBuilder<T> arguments(Object ... arguments) {
        return this.arguments(Arrays.asList(arguments));
    }

    public RepositoryItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public RepositoryItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public RepositoryItemReaderBuilder<T> repository(PagingAndSortingRepository<?, ?> repository) {
        this.repository = repository;
        return this;
    }

    public RepositoryItemReaderBuilder<T> methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public RepositoryItemReader<T> build() {
        Assert.notNull(this.sorts, (String)"sorts map is required.");
        Assert.notNull(this.repository, (String)"repository is required.");
        Assert.hasText((String)this.methodName, (String)"methodName is required.");
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        RepositoryItemReader reader = new RepositoryItemReader();
        reader.setArguments(this.arguments);
        reader.setRepository(this.repository);
        reader.setMethodName(this.methodName);
        reader.setPageSize(this.pageSize);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setSaveState(this.saveState);
        reader.setSort(this.sorts);
        reader.setName(this.name);
        return reader;
    }
}

