/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongoItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final String ID_KEY = "_id";
    private MongoOperations template;
    private final Object bufferKey = new Object();
    private String collection;
    private boolean delete = false;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    protected MongoOperations getTemplate() {
        return this.template;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        if (!this.transactionActive()) {
            this.doWrite(chunk);
            return;
        }
        Chunk<T> bufferedItems = this.getCurrentBuffer();
        bufferedItems.addAll(chunk.getItems());
    }

    protected void doWrite(Chunk<? extends T> chunk) {
        if (!CollectionUtils.isEmpty(chunk.getItems())) {
            if (this.delete) {
                this.delete(chunk);
            } else {
                this.saveOrUpdate(chunk);
            }
        }
    }

    private void delete(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Object objectId = document.get((Object)ID_KEY);
            if (objectId == null) continue;
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            bulkOperations.remove(query);
        }
        bulkOperations.execute();
    }

    private void saveOrUpdate(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        FindAndReplaceOptions upsert = new FindAndReplaceOptions().upsert();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Object objectId = document.get((Object)ID_KEY) != null ? document.get((Object)ID_KEY) : new ObjectId();
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            bulkOperations.replaceOne(query, (Object)document, upsert);
        }
        bulkOperations.execute();
    }

    private BulkOperations initBulkOperations(BulkOperations.BulkMode bulkMode, Object item) {
        BulkOperations bulkOperations = StringUtils.hasText((String)this.collection) ? this.template.bulkOps(bulkMode, this.collection) : this.template.bulkOps(bulkMode, ClassUtils.getUserClass((Object)item));
        return bulkOperations;
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    private Chunk<T> getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.bufferKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.bufferKey, new Chunk<Object>(new Object[0]));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void beforeCommit(boolean readOnly) {
                    Chunk chunk = (Chunk)TransactionSynchronizationManager.getResource((Object)MongoItemWriter.this.bufferKey);
                    if (!CollectionUtils.isEmpty(chunk.getItems()) && !readOnly) {
                        MongoItemWriter.this.doWrite(chunk);
                    }
                }

                public void afterCompletion(int status) {
                    if (TransactionSynchronizationManager.hasResource((Object)MongoItemWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource((Object)MongoItemWriter.this.bufferKey);
                    }
                }
            });
        }
        return (Chunk)TransactionSynchronizationManager.getResource((Object)this.bufferKey);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.template != null ? 1 : 0) != 0, (String)"A MongoOperations implementation is required.");
    }
}

