/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.item.WriterNotOpenException;
import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.support.AbstractItemStreamItemWriter;
import org.springframework.batch.item.util.FileUtils;
import org.springframework.batch.support.transaction.TransactionAwareBufferedWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public abstract class AbstractFileItemWriter<T>
extends AbstractItemStreamItemWriter<T>
implements ResourceAwareItemWriterItemStream<T>,
InitializingBean {
    public static final boolean DEFAULT_TRANSACTIONAL = true;
    protected static final Log logger = LogFactory.getLog(AbstractFileItemWriter.class);
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    private static final String WRITTEN_STATISTICS_NAME = "written";
    private static final String RESTART_DATA_NAME = "current.count";
    private WritableResource resource;
    protected OutputState state = null;
    private boolean saveState = true;
    private boolean forceSync = false;
    protected boolean shouldDeleteIfExists = true;
    private boolean shouldDeleteIfEmpty = false;
    private String encoding = DEFAULT_CHARSET;
    private FlatFileHeaderCallback headerCallback;
    private FlatFileFooterCallback footerCallback;
    protected String lineSeparator = DEFAULT_LINE_SEPARATOR;
    private boolean transactional = true;
    protected boolean append = false;

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Override
    public void setResource(WritableResource resource) {
        this.resource = resource;
    }

    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public void setShouldDeleteIfExists(boolean shouldDeleteIfExists) {
        this.shouldDeleteIfExists = shouldDeleteIfExists;
    }

    public void setAppendAllowed(boolean append) {
        this.append = append;
    }

    public void setShouldDeleteIfEmpty(boolean shouldDeleteIfEmpty) {
        this.shouldDeleteIfEmpty = shouldDeleteIfEmpty;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void setHeaderCallback(FlatFileHeaderCallback headerCallback) {
        this.headerCallback = headerCallback;
    }

    public void setFooterCallback(FlatFileFooterCallback footerCallback) {
        this.footerCallback = footerCallback;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        if (!this.getOutputState().isInitialized()) {
            throw new WriterNotOpenException("Writer must be open before it can be written to");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing to file with " + items.size() + " items."));
        }
        OutputState state = this.getOutputState();
        String lines = this.doWrite(items);
        try {
            state.write(lines);
        }
        catch (IOException e) {
            throw new WriteFailedException("Could not write data. The file may be corrupt.", e);
        }
        state.setLinesWritten(state.getLinesWritten() + (long)items.size());
    }

    protected abstract String doWrite(Chunk<? extends T> var1);

    @Override
    public void close() {
        super.close();
        if (this.state != null) {
            try {
                if (this.footerCallback != null && this.state.outputBufferedWriter != null) {
                    this.footerCallback.writeFooter(this.state.outputBufferedWriter);
                    this.state.outputBufferedWriter.flush();
                }
            }
            catch (IOException e) {
                throw new ItemStreamException("Failed to write footer before closing", e);
            }
            finally {
                this.state.close();
                if (this.state.linesWritten == 0L && this.shouldDeleteIfEmpty) {
                    try {
                        if (!this.resource.getFile().delete()) {
                            throw new ItemStreamException("Failed to delete empty file on close");
                        }
                    }
                    catch (IOException e) {
                        throw new ItemStreamException("Failed to delete empty file on close", e);
                    }
                }
                this.state = null;
            }
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        Assert.notNull((Object)this.resource, (String)"The resource must be set");
        if (!this.getOutputState().isInitialized()) {
            this.doOpen(executionContext);
        }
    }

    private void doOpen(ExecutionContext executionContext) throws ItemStreamException {
        OutputState outputState = this.getOutputState();
        if (executionContext.containsKey(this.getExecutionContextKey(RESTART_DATA_NAME))) {
            outputState.restoreFrom(executionContext);
        }
        try {
            outputState.initializeBufferedWriter();
        }
        catch (IOException ioe) {
            throw new ItemStreamException("Failed to initialize writer", ioe);
        }
        if (outputState.lastMarkedByteOffsetPosition == 0L && !outputState.appending && this.headerCallback != null) {
            try {
                this.headerCallback.writeHeader(outputState.outputBufferedWriter);
                outputState.write(this.lineSeparator);
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not write headers.  The file may be corrupt.", e);
            }
        }
    }

    @Override
    public void update(ExecutionContext executionContext) {
        super.update(executionContext);
        if (this.state == null) {
            throw new ItemStreamException("ItemStream not open or already closed.");
        }
        Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
        if (this.saveState) {
            try {
                executionContext.putLong(this.getExecutionContextKey(RESTART_DATA_NAME), this.state.position());
            }
            catch (IOException e) {
                throw new ItemStreamException("ItemStream does not return current position properly", e);
            }
            executionContext.putLong(this.getExecutionContextKey(WRITTEN_STATISTICS_NAME), this.state.linesWritten);
        }
    }

    protected OutputState getOutputState() {
        if (this.state == null) {
            File file;
            try {
                file = this.resource.getFile();
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not convert resource to file: [" + this.resource + "]", e);
            }
            Assert.state((!file.exists() || file.canWrite() ? 1 : 0) != 0, (String)("Resource is not writable: [" + this.resource + "]"));
            this.state = new OutputState();
            this.state.setDeleteIfExists(this.shouldDeleteIfExists);
            this.state.setAppendAllowed(this.append);
            this.state.setEncoding(this.encoding);
        }
        return this.state;
    }

    protected class OutputState {
        private FileOutputStream os;
        Writer outputBufferedWriter;
        FileChannel fileChannel;
        String encoding = DEFAULT_CHARSET;
        boolean restarted = false;
        long lastMarkedByteOffsetPosition = 0L;
        long linesWritten = 0L;
        boolean shouldDeleteIfExists = true;
        boolean initialized = false;
        private boolean append = false;
        private boolean appending = false;

        protected OutputState() {
        }

        public long position() throws IOException {
            long pos = 0L;
            if (this.fileChannel == null) {
                return 0L;
            }
            this.outputBufferedWriter.flush();
            pos = this.fileChannel.position();
            if (AbstractFileItemWriter.this.transactional) {
                pos += ((TransactionAwareBufferedWriter)this.outputBufferedWriter).getBufferSize();
            }
            return pos;
        }

        public void setAppendAllowed(boolean append) {
            this.append = append;
        }

        public void restoreFrom(ExecutionContext executionContext) {
            this.lastMarkedByteOffsetPosition = executionContext.getLong(AbstractFileItemWriter.this.getExecutionContextKey(AbstractFileItemWriter.RESTART_DATA_NAME));
            this.linesWritten = executionContext.getLong(AbstractFileItemWriter.this.getExecutionContextKey(AbstractFileItemWriter.WRITTEN_STATISTICS_NAME));
            if (AbstractFileItemWriter.this.shouldDeleteIfEmpty && this.linesWritten == 0L) {
                this.restarted = false;
                this.lastMarkedByteOffsetPosition = 0L;
            } else {
                this.restarted = true;
            }
        }

        public void setDeleteIfExists(boolean shouldDeleteIfExists) {
            this.shouldDeleteIfExists = shouldDeleteIfExists;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public long getLinesWritten() {
            return this.linesWritten;
        }

        public void setLinesWritten(long linesWritten) {
            this.linesWritten = linesWritten;
        }

        public void close() {
            this.initialized = false;
            this.restarted = false;
            try {
                if (this.outputBufferedWriter != null) {
                    this.outputBufferedWriter.close();
                }
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Unable to close the ItemWriter", ioe);
            }
            finally {
                if (!AbstractFileItemWriter.this.transactional) {
                    this.closeStream();
                }
            }
        }

        private void closeStream() {
            try {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Unable to close the ItemWriter", ioe);
            }
            finally {
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ioe) {
                    throw new ItemStreamException("Unable to close the ItemWriter", ioe);
                }
            }
        }

        public void write(String line) throws IOException {
            if (!this.initialized) {
                this.initializeBufferedWriter();
            }
            this.outputBufferedWriter.write(line);
            this.outputBufferedWriter.flush();
        }

        public void truncate() throws IOException {
            this.fileChannel.truncate(this.lastMarkedByteOffsetPosition);
            this.fileChannel.position(this.lastMarkedByteOffsetPosition);
        }

        private void initializeBufferedWriter() throws IOException {
            File file = AbstractFileItemWriter.this.resource.getFile();
            FileUtils.setUpOutputFile(file, this.restarted, this.append, this.shouldDeleteIfExists);
            this.os = new FileOutputStream(file.getAbsolutePath(), true);
            this.fileChannel = this.os.getChannel();
            this.outputBufferedWriter = this.getBufferedWriter(this.fileChannel, this.encoding);
            this.outputBufferedWriter.flush();
            if (this.append && file.length() > 0L) {
                this.appending = true;
            }
            Assert.state((this.outputBufferedWriter != null ? 1 : 0) != 0, (String)"Unable to initialize buffered writer");
            if (this.restarted) {
                this.checkFileSize();
                this.truncate();
            }
            this.initialized = true;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        private Writer getBufferedWriter(FileChannel fileChannel, String encoding) {
            try {
                final FileChannel channel = fileChannel;
                if (AbstractFileItemWriter.this.transactional) {
                    TransactionAwareBufferedWriter writer = new TransactionAwareBufferedWriter(channel, this::closeStream);
                    writer.setEncoding(encoding);
                    writer.setForceSync(AbstractFileItemWriter.this.forceSync);
                    return writer;
                }
                return new BufferedWriter(Channels.newWriter((WritableByteChannel)fileChannel, encoding)){

                    @Override
                    public void flush() throws IOException {
                        super.flush();
                        if (AbstractFileItemWriter.this.forceSync) {
                            channel.force(false);
                        }
                    }
                };
            }
            catch (UnsupportedCharsetException ucse) {
                throw new ItemStreamException("Bad encoding configuration for output file " + fileChannel, ucse);
            }
        }

        private void checkFileSize() throws IOException {
            this.outputBufferedWriter.flush();
            long size = this.fileChannel.size();
            if (size < this.lastMarkedByteOffsetPosition) {
                throw new ItemStreamException("Current file size is smaller than size at last commit");
            }
        }
    }
}

