/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RangeArrayPropertyEditor
extends PropertyEditorSupport {
    private boolean forceDisjointRanges = false;

    public void setForceDisjointRanges(boolean forceDisjointRanges) {
        this.forceDisjointRanges = forceDisjointRanges;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String[] strRanges = text.split(",");
        Range[] ranges = new Range[strRanges.length];
        for (int i = 0; i < strRanges.length; ++i) {
            int min;
            String[] range = strRanges[i].split("-");
            if (range.length == 1 && StringUtils.hasText((String)range[0])) {
                min = Integer.parseInt(range[0].trim());
                ranges[i] = new Range(min);
                continue;
            }
            if (range.length == 2 && StringUtils.hasText((String)range[0]) && StringUtils.hasText((String)range[1])) {
                min = Integer.parseInt(range[0].trim());
                int max = Integer.parseInt(range[1].trim());
                ranges[i] = new Range(min, max);
                continue;
            }
            throw new IllegalArgumentException("Range[" + i + "]: range (" + strRanges[i] + ") is invalid");
        }
        this.setMaxValues(ranges);
        this.setValue(ranges);
    }

    @Override
    public String getAsText() {
        Range[] ranges = (Range[])this.getValue();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ranges[i]);
        }
        return sb.toString();
    }

    private void setMaxValues(Range[] ranges) {
        int i;
        Integer[] c = new Integer[ranges.length];
        for (i = 0; i < c.length; ++i) {
            c[i] = i;
        }
        Arrays.sort(c, Comparator.comparingInt(r -> ranges[r].getMin()));
        for (i = 0; i < c.length - 1; ++i) {
            if (ranges[c[i]].hasMaxValue()) continue;
            ranges[c[i].intValue()] = new Range(ranges[c[i]].getMin(), ranges[c[i + 1]].getMin() - 1);
        }
        if (this.forceDisjointRanges) {
            this.verifyRanges(ranges);
        }
    }

    private void verifyRanges(Range[] ranges) {
        for (int i = 1; i < ranges.length; ++i) {
            Assert.isTrue((ranges[i - 1].getMax() < ranges[i].getMin() ? 1 : 0) != 0, (String)("Ranges must be disjoint. Range[" + (i - 1) + "]: (" + String.valueOf(ranges[i - 1]) + ") Range[" + i + "]: (" + String.valueOf(ranges[i]) + ")"));
        }
    }
}

