/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.BufferedReaderFactory;
import org.springframework.core.io.Resource;

public class SimpleBinaryBufferedReaderFactory
implements BufferedReaderFactory {
    private static final String DEFAULT_LINE_ENDING = "\n";
    private String lineEnding = "\n";

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    @Override
    public BufferedReader create(Resource resource, String encoding) throws IOException {
        return new BinaryBufferedReader((Reader)new InputStreamReader(resource.getInputStream(), encoding), this.lineEnding);
    }

    private static final class BinaryBufferedReader
    extends BufferedReader {
        private final String ending;
        private final Lock lock = new ReentrantLock();

        private BinaryBufferedReader(Reader in, String ending) {
            super(in);
            this.ending = ending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable String readLine() throws IOException {
            StringBuilder buffer;
            this.lock.lock();
            try {
                int next = this.read();
                if (next == -1) {
                    String string = null;
                    return string;
                }
                buffer = new StringBuilder();
                StringBuilder candidateEnding = new StringBuilder();
                while (!this.isEndOfLine(buffer, candidateEnding, next)) {
                    next = this.read();
                }
                buffer.append((CharSequence)candidateEnding);
            }
            finally {
                this.lock.unlock();
            }
            if (buffer != null && buffer.length() > 0) {
                return buffer.toString();
            }
            return null;
        }

        private boolean isEndOfLine(StringBuilder buffer, StringBuilder candidate, int next) {
            if (next == -1) {
                return true;
            }
            char c = (char)next;
            if (this.ending.charAt(0) != c && candidate.isEmpty()) {
                buffer.append(c);
                return false;
            }
            candidate.append(c);
            if (this.ending.contentEquals(candidate)) {
                candidate.delete(0, candidate.length());
                return true;
            }
            while (!this.ending.startsWith(candidate.toString())) {
                buffer.append(candidate.charAt(0));
                candidate.delete(0, 1);
            }
            return false;
        }
    }
}

