/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.ldif.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ldif.LdifReader;
import org.springframework.batch.infrastructure.item.ldif.RecordCallbackHandler;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LdifReaderBuilder {
    private @Nullable Resource resource;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private @Nullable RecordCallbackHandler skippedRecordsCallback;
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public LdifReaderBuilder saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public LdifReaderBuilder name(String name) {
        this.name = name;
        return this;
    }

    public LdifReaderBuilder maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public LdifReaderBuilder currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public LdifReaderBuilder strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public LdifReaderBuilder skippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
        return this;
    }

    public LdifReaderBuilder recordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
        return this;
    }

    public LdifReaderBuilder resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public LdifReader build() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Resource is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        LdifReader reader = new LdifReader(this.resource);
        reader.setRecordsToSkip(this.recordsToSkip);
        reader.setSaveState(this.saveState);
        if (this.name != null) {
            reader.setName(this.name);
        }
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        if (this.skippedRecordsCallback != null) {
            reader.setSkippedRecordsCallback(this.skippedRecordsCallback);
        }
        reader.setStrict(this.strict);
        reader.afterPropertiesSet();
        return reader;
    }
}

