/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemReader;

public class BlockingQueueItemReader<T>
implements ItemReader<T> {
    private final BlockingQueue<T> queue;
    private long timeout = 1L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    public BlockingQueueItemReader(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public @Nullable T read() throws Exception {
        return this.queue.poll(this.timeout, this.timeUnit);
    }
}

