/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.Payloads;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessagingOperations;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MessageEndpoint
public class MessageChannelPartitionHandler
implements PartitionHandler {
    private static Log logger = LogFactory.getLog(MessageChannelPartitionHandler.class);
    private int gridSize = 1;
    private MessagingOperations messagingGateway;
    private String stepName;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.stepName, (String)"A step name must be provided for the remote workers.");
        Assert.state((this.messagingGateway != null ? 1 : 0) != 0, (String)"The MessagingOperations must be set");
    }

    public void setMessagingOperations(MessagingOperations messagingGateway) {
        this.messagingGateway = messagingGateway;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    @Aggregator(sendPartialResultsOnExpiry=true)
    public List<?> aggregate(@Payloads List<?> messages) {
        return messages;
    }

    public Collection<StepExecution> handle(StepExecutionSplitter stepExecutionSplitter, StepExecution masterStepExecution) throws Exception {
        Set split = stepExecutionSplitter.split(masterStepExecution, this.gridSize);
        int count = 0;
        QueueChannel replyChannel = new QueueChannel();
        for (StepExecution stepExecution : split) {
            Message<StepExecutionRequest> request = this.createMessage(count++, split.size(), new StepExecutionRequest(this.stepName, stepExecution.getJobExecutionId(), stepExecution.getId()), (PollableChannel)replyChannel);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending request: " + request));
            }
            this.messagingGateway.send(request);
        }
        Message message = this.messagingGateway.receive((PollableChannel)replyChannel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received replies: " + message));
        }
        Collection result = (Collection)message.getPayload();
        return result;
    }

    private Message<StepExecutionRequest> createMessage(int sequenceNumber, int sequenceSize, StepExecutionRequest stepExecutionRequest, PollableChannel replyChannel) {
        return MessageBuilder.withPayload((Object)stepExecutionRequest).setSequenceNumber(Integer.valueOf(sequenceNumber)).setSequenceSize(Integer.valueOf(sequenceSize)).setCorrelationId((Object)(stepExecutionRequest.getJobExecutionId() + ":" + stepExecutionRequest.getStepName())).setReplyChannel((MessageChannel)replyChannel).build();
    }
}

