/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AsyncItemWriter<T>
implements ItemWriter<Future<T>>,
InitializingBean {
    private ItemWriter<T> delegate;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"A delegate ItemWriter must be provided.");
    }

    public void setDelegate(ItemWriter<T> delegate) {
        this.delegate = delegate;
    }

    public void write(List<? extends Future<T>> items) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        for (Future<T> future : items) {
            list.add(future.get());
        }
        this.delegate.write(list);
    }
}

