/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.test.StepRunner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractJobTests
implements ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private JobLauncher launcher;
    @Autowired
    private AbstractJob job;
    @Autowired
    private JobRepository jobRepository;
    private StepRunner stepRunner;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public AbstractJob getJob() {
        return this.job;
    }

    protected JobLauncher getJobLauncher() {
        return this.launcher;
    }

    protected JobExecution launchJob() throws Exception {
        return this.launchJob(this.getUniqueJobParameters());
    }

    protected JobExecution launchJob(JobParameters jobParameters) throws Exception {
        return this.getJobLauncher().run((Job)this.job, jobParameters);
    }

    protected JobParameters getUniqueJobParameters() {
        HashMap<String, JobParameter> parameters = new HashMap<String, JobParameter>();
        parameters.put("timestamp", new JobParameter(Long.valueOf(new Date().getTime())));
        return new JobParameters(parameters);
    }

    protected StepRunner getStepRunner() {
        if (this.stepRunner == null) {
            this.stepRunner = new StepRunner(this.getJobLauncher(), this.getJobRepository());
        }
        return this.stepRunner;
    }

    public JobExecution launchStep(String stepName) {
        return this.launchStep(stepName, this.getUniqueJobParameters(), null);
    }

    public JobExecution launchStep(String stepName, ExecutionContext jobExecutionContext) {
        return this.launchStep(stepName, this.getUniqueJobParameters(), jobExecutionContext);
    }

    public JobExecution launchStep(String stepName, JobParameters jobParameters) {
        return this.launchStep(stepName, jobParameters, null);
    }

    public JobExecution launchStep(String stepName, JobParameters jobParameters, ExecutionContext jobExecutionContext) {
        Step step = this.job.getStep(stepName);
        if (step == null) {
            step = this.job.getStep(String.valueOf(this.job.getName()) + "." + stepName);
        }
        if (step == null) {
            throw new IllegalStateException("No Step found with name: [" + stepName + "]");
        }
        return this.getStepRunner().launchStep(step, jobParameters, jobExecutionContext);
    }
}

