/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobRepositoryTestUtils
extends AbstractJdbcBatchMetadataDao
implements InitializingBean {
    private JobRepository jobRepository;
    private JobParametersIncrementer jobParametersIncrementer = new JobParametersIncrementer(){
        Long count = 0L;

        public JobParameters getNext(JobParameters parameters) {
            Long l = this.count;
            this.count = l + 1L;
            return new JobParameters(Collections.singletonMap("count", new JobParameter(l)));
        }
    };
    private SimpleJdbcOperations jdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be set");
        Assert.notNull((Object)this.jdbcTemplate, (String)"DataSource must be set");
    }

    public JobRepositoryTestUtils() {
    }

    public JobRepositoryTestUtils(JobRepository jobRepository, DataSource dataSource) {
        this.jobRepository = jobRepository;
        this.setDataSource(dataSource);
    }

    public final void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public List<JobExecution> createJobExecutions(String jobName, String[] stepNames, int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ArrayList<JobExecution> list = new ArrayList<JobExecution>();
        JobParameters jobParameters = new JobParameters();
        int i = 0;
        while (i < count) {
            JobExecution jobExecution = this.jobRepository.createJobExecution(jobName, this.jobParametersIncrementer.getNext(jobParameters));
            list.add(jobExecution);
            String[] stringArray = stepNames;
            int n = stepNames.length;
            int n2 = 0;
            while (n2 < n) {
                String stepName = stringArray[n2];
                this.jobRepository.add(jobExecution.createStepExecution(stepName));
                ++n2;
            }
            ++i;
        }
        return list;
    }

    public List<JobExecution> createJobExecutions(int count) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        return this.createJobExecutions("job", new String[]{"step"}, count);
    }

    public void removeJobExecutions(Collection<JobExecution> list) throws DataAccessException {
        for (JobExecution jobExecution : list) {
            List stepExecutionIds = this.jdbcTemplate.query(this.getQuery("select STEP_EXECUTION_ID from %PREFIX%STEP_EXECUTION where JOB_EXECUTION_ID=?"), (ParameterizedRowMapper)new ParameterizedRowMapper<Long>(){

                public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getLong(1);
                }
            }, new Object[]{jobExecution.getId()});
            for (Long stepExecutionId : stepExecutionIds) {
                this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION_CONTEXT where STEP_EXECUTION_ID=?"), new Object[]{stepExecutionId});
                this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION where STEP_EXECUTION_ID=?"), new Object[]{stepExecutionId});
            }
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION_CONTEXT where JOB_EXECUTION_ID=?"), new Object[]{jobExecution.getId()});
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID=?"), new Object[]{jobExecution.getId()});
        }
        for (JobExecution jobExecution : list) {
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_PARAMS where JOB_INSTANCE_ID=?"), new Object[]{jobExecution.getJobId()});
            this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_INSTANCE where JOB_INSTANCE_ID=?"), new Object[]{jobExecution.getJobId()});
        }
    }

    public void removeJobExecutions() throws DataAccessException {
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION_CONTEXT"), new Object[0]);
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%STEP_EXECUTION"), new Object[0]);
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION_CONTEXT"), new Object[0]);
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_EXECUTION"), new Object[0]);
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_PARAMS"), new Object[0]);
        this.jdbcTemplate.update(this.getQuery("delete from %PREFIX%JOB_INSTANCE"), new Object[0]);
    }
}

