/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.lang.Nullable;

public class StepRunner {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JobLauncher launcher;
    private JobRepository jobRepository;

    public StepRunner(JobLauncher launcher, JobRepository jobRepository) {
        this.launcher = launcher;
        this.jobRepository = jobRepository;
    }

    public JobExecution launchStep(Step step) {
        return this.launchStep(step, this.makeUniqueJobParameters(), null);
    }

    public JobExecution launchStep(Step step, @Nullable ExecutionContext jobExecutionContext) {
        return this.launchStep(step, this.makeUniqueJobParameters(), jobExecutionContext);
    }

    public JobExecution launchStep(Step step, JobParameters jobParameters) {
        return this.launchStep(step, jobParameters, null);
    }

    public JobExecution launchStep(Step step, JobParameters jobParameters, final @Nullable ExecutionContext jobExecutionContext) {
        SimpleJob job = new SimpleJob();
        job.setName("TestJob");
        job.setJobRepository(this.jobRepository);
        ArrayList<Step> stepsToExecute = new ArrayList<Step>();
        stepsToExecute.add(step);
        job.setSteps(stepsToExecute);
        if (jobExecutionContext != null && !jobExecutionContext.isEmpty()) {
            job.setJobExecutionListeners(new JobExecutionListener[]{new JobExecutionListenerSupport(){

                public void beforeJob(JobExecution jobExecution) {
                    ExecutionContext jobContext = jobExecution.getExecutionContext();
                    for (Map.Entry entry : jobExecutionContext.entrySet()) {
                        jobContext.put((String)entry.getKey(), entry.getValue());
                    }
                }
            }});
        }
        return this.launchJob((Job)job, jobParameters);
    }

    private JobExecution launchJob(Job job, JobParameters jobParameters) {
        try {
            return this.launcher.run(job, jobParameters);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new UnexpectedJobExecutionException("Step runner encountered exception.", (Throwable)e);
        }
        catch (JobRestartException e) {
            throw new UnexpectedJobExecutionException("Step runner encountered exception.", (Throwable)e);
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new UnexpectedJobExecutionException("Step runner encountered exception.", (Throwable)e);
        }
        catch (JobParametersInvalidException e) {
            throw new UnexpectedJobExecutionException("Step runner encountered exception.", (Throwable)e);
        }
    }

    private JobParameters makeUniqueJobParameters() {
        HashMap<String, JobParameter> parameters = new HashMap<String, JobParameter>();
        parameters.put("timestamp", new JobParameter(Long.valueOf(new Date().getTime())));
        return new JobParameters(parameters);
    }
}

