/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.job.UnexpectedJobExecutionException;
import org.springframework.batch.core.job.parameters.InvalidJobParametersException;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.job.parameters.JobParametersBuilder;
import org.springframework.batch.core.launch.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.launch.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.JobRestartException;
import org.springframework.batch.core.listener.JobExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.Step;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.test.JobLauncherTestUtils;
import org.springframework.util.Assert;

public class JobOperatorTestUtils
extends JobLauncherTestUtils {
    public static final String JOB_NAME = "TestJob";
    protected JobOperator jobOperator;

    public JobOperatorTestUtils(JobOperator jobOperator, JobRepository jobRepository) {
        Assert.notNull((Object)jobOperator, (String)"JobOperator must not be null");
        Assert.notNull((Object)jobRepository, (String)"JobRepository must not be null");
        this.jobOperator = jobOperator;
        this.jobRepository = jobRepository;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    public void setJobOperator(JobOperator jobOperator) {
        this.jobOperator = jobOperator;
    }

    @Override
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public JobExecution startJob() throws Exception {
        return this.startJob(super.getUniqueJobParameters());
    }

    public JobExecution startJob(JobParameters jobParameters) throws Exception {
        return this.jobOperator.start(this.job, jobParameters);
    }

    public JobExecution startStep(String stepName) {
        return this.startStep(stepName, this.getUniqueJobParameters(), new ExecutionContext());
    }

    public JobExecution startStep(String stepName, JobParameters jobParameters, ExecutionContext jobExecutionContext) {
        if (!(this.job instanceof StepLocator)) {
            throw new UnsupportedOperationException("Cannot locate step from a Job that is not a StepLocator: job=" + this.job.getName() + " does not implement StepLocator");
        }
        StepLocator locator = (StepLocator)this.job;
        Step step = locator.getStep(stepName);
        if (step == null) {
            step = locator.getStep(this.job.getName() + "." + stepName);
        }
        if (step == null) {
            throw new IllegalStateException("No Step found with name: [" + stepName + "]");
        }
        return this.startStep(step, jobParameters, jobExecutionContext);
    }

    public JobExecution startStep(Step step) {
        return this.startStep(step, this.getUniqueJobParameters(), new ExecutionContext());
    }

    public JobExecution startStep(Step step, JobParameters jobParameters, final ExecutionContext jobExecutionContext) {
        SimpleJob job = new SimpleJob();
        job.setName(JOB_NAME);
        job.setJobRepository(this.jobRepository);
        ArrayList<Step> stepsToExecute = new ArrayList<Step>();
        stepsToExecute.add(step);
        job.setSteps(stepsToExecute);
        if (jobExecutionContext != null && !jobExecutionContext.isEmpty()) {
            job.setJobExecutionListeners(new JobExecutionListener[]{new JobExecutionListener(){
                final /* synthetic */ JobOperatorTestUtils this$0;
                {
                    this.this$0 = this$0;
                }

                public void beforeJob(JobExecution jobExecution) {
                    ExecutionContext jobContext = jobExecution.getExecutionContext();
                    for (Map.Entry entry : jobExecutionContext.entrySet()) {
                        jobContext.put((String)entry.getKey(), entry.getValue());
                    }
                }
            }});
        }
        try {
            return this.jobOperator.start((Job)job, jobParameters);
        }
        catch (InvalidJobParametersException | JobExecutionAlreadyRunningException | JobInstanceAlreadyCompleteException | JobRestartException e) {
            throw new UnexpectedJobExecutionException("Step runner encountered exception.", e);
        }
    }

    @Override
    public JobParameters getUniqueJobParameters() {
        return super.getUniqueJobParameters();
    }

    @Override
    public JobParametersBuilder getUniqueJobParametersBuilder() {
        return super.getUniqueJobParametersBuilder();
    }
}

