/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.installer;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.installer.ArtifactInstallationException;
import hidden.org.apache.maven.artifact.installer.ArtifactInstaller;
import hidden.org.apache.maven.artifact.metadata.ArtifactMetadata;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import hidden.org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import hidden.org.apache.maven.artifact.repository.metadata.MetadataBridge;
import hidden.org.apache.maven.artifact.repository.metadata.Snapshot;
import hidden.org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import hidden.org.apache.maven.artifact.repository.metadata.Versioning;
import hidden.org.apache.maven.plugin.LegacySupport;
import hidden.org.apache.maven.project.artifact.ProjectArtifactMetadata;
import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.installation.InstallRequest;
import hidden.org.eclipse.aether.installation.InstallationException;
import hidden.org.eclipse.aether.util.artifact.SubArtifact;
import java.io.File;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArtifactInstaller.class)
public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private LegacySupport legacySupport;

    @Override
    @Deprecated
    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.install(source, artifact, localRepository);
    }

    @Override
    public void install(File source, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        RepositorySystemSession session = LegacyLocalRepositoryManager.overlay(localRepository, this.legacySupport.getRepositorySession(), this.repoSystem);
        InstallRequest request = new InstallRequest();
        request.setTrace(RequestTrace.newChild(null, this.legacySupport.getSession().getCurrentProject()));
        hidden.org.eclipse.aether.artifact.Artifact mainArtifact = RepositoryUtils.toArtifact(artifact);
        mainArtifact = mainArtifact.setFile(source);
        request.addArtifact(mainArtifact);
        for (ArtifactMetadata metadata : artifact.getMetadataList()) {
            if (metadata instanceof ProjectArtifactMetadata) {
                hidden.org.eclipse.aether.artifact.Artifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                request.addArtifact(pomArtifact);
                continue;
            }
            if (metadata instanceof SnapshotArtifactRepositoryMetadata || metadata instanceof ArtifactRepositoryMetadata) continue;
            request.addMetadata(new MetadataBridge(metadata));
        }
        try {
            this.repoSystem.install(session, request);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallationException(e.getMessage(), e);
        }
        if (artifact.isSnapshot()) {
            Snapshot snapshot = new Snapshot();
            snapshot.setLocalCopy(true);
            artifact.addMetadata(new SnapshotArtifactRepositoryMetadata(artifact, snapshot));
        }
        Versioning versioning = new Versioning();
        versioning.updateTimestamp();
        versioning.addVersion(artifact.getBaseVersion());
        if (artifact.isRelease()) {
            versioning.setRelease(artifact.getBaseVersion());
        }
        artifact.addMetadata(new ArtifactRepositoryMetadata(artifact, versioning));
    }
}

