/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.bridge;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.DefaultArtifact;
import hidden.org.apache.maven.artifact.InvalidRepositoryException;
import hidden.org.apache.maven.artifact.handler.ArtifactHandler;
import hidden.org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import hidden.org.apache.maven.artifact.repository.Authentication;
import hidden.org.apache.maven.artifact.repository.MavenArtifactRepository;
import hidden.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import hidden.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout2;
import hidden.org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import hidden.org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import hidden.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import hidden.org.apache.maven.artifact.versioning.VersionRange;
import hidden.org.apache.maven.execution.MavenExecutionRequest;
import hidden.org.apache.maven.model.Dependency;
import hidden.org.apache.maven.model.Exclusion;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.model.RepositoryPolicy;
import hidden.org.apache.maven.repository.Proxy;
import hidden.org.apache.maven.settings.Mirror;
import hidden.org.apache.maven.settings.Repository;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.repository.AuthenticationContext;
import hidden.org.eclipse.aether.repository.AuthenticationSelector;
import hidden.org.eclipse.aether.repository.MirrorSelector;
import hidden.org.eclipse.aether.repository.ProxySelector;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

@Component(role=MavenRepositorySystem.class, hint="default")
public class MavenRepositorySystem {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> layouts;
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.XcreateArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String metaVersionId) {
        return this.XcreateProjectArtifact(groupId, artifactId, metaVersionId);
    }

    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        if (d.getVersion() == null) {
            return null;
        }
        try {
            versionRange = VersionRange.createFromVersionSpec(d.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        Artifact artifact = this.XcreateDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
        if ("system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : d.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ':' + exclusion.getArtifactId());
            }
            artifact.setDependencyFilter(new ExcludesArtifactFilter(exclusions));
        }
        return artifact;
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, String version) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec(version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.XcreateExtensionArtifact(groupId, artifactId, versionRange);
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.XcreateParentArtifact(groupId, artifactId, version);
    }

    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        try {
            String version = plugin.getVersion();
            if (StringUtils.isEmpty(version)) {
                version = "RELEASE";
            }
            versionRange = VersionRange.createFromVersionSpec(version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.XcreatePluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
    }

    public void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = MavenRepositorySystem.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private Mirror getMirror(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        MirrorSelector selector;
        if (session != null && (selector = session.getMirrorSelector()) != null && (repo = selector.getMirror(RepositoryUtils.toRepo(repository))) != null) {
            Mirror mirror = new Mirror();
            mirror.setId(repo.getId());
            mirror.setUrl(repo.getUrl());
            mirror.setLayout(repo.getContentType());
            return mirror;
        }
        return null;
    }

    public void injectMirror(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(session, repository);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = MavenRepositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (StringUtils.isNotEmpty(mirror.getLayout())) {
                repository.setLayout(this.getLayout(mirror.getLayout()));
            }
        }
    }

    private Authentication getAuthentication(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        hidden.org.eclipse.aether.repository.Authentication auth;
        AuthenticationSelector selector;
        if (session != null && (selector = session.getAuthenticationSelector()) != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo(repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository(session, repo);
            Authentication result = new Authentication(authCtx.get("username"), authCtx.get("password"));
            result.setPrivateKey(authCtx.get("privateKey.path"));
            result.setPassphrase(authCtx.get("privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }

    public void injectAuthentication(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(session, repository));
            }
        }
    }

    private Proxy getProxy(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        hidden.org.eclipse.aether.repository.Proxy proxy;
        ProxySelector selector;
        if (session != null && (selector = session.getProxySelector()) != null && (proxy = selector.getProxy(repo = RepositoryUtils.toRepo(repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy.getHost());
            p.setProtocol(proxy.getType());
            p.setPort(proxy.getPort());
            if (proxy.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy(session, repo);
                p.setUserName(authCtx.get("username"));
                p.setPassword(authCtx.get("password"));
                p.setNtlmDomain(authCtx.get("ntlm.domain"));
                p.setNtlmHost(authCtx.get("ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    public void injectProxy(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(session, repository));
            }
        }
    }

    private ArtifactRepositoryLayout getLayout(String id) {
        ArtifactRepositoryLayout layout = this.layouts.get(id);
        return layout;
    }

    public static hidden.org.apache.maven.model.Repository fromSettingsRepository(Repository settingsRepository) {
        hidden.org.apache.maven.model.Repository modelRepository = new hidden.org.apache.maven.model.Repository();
        modelRepository.setId(settingsRepository.getId());
        modelRepository.setLayout(settingsRepository.getLayout());
        modelRepository.setName(settingsRepository.getName());
        modelRepository.setUrl(settingsRepository.getUrl());
        modelRepository.setReleases(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getReleases()));
        modelRepository.setSnapshots(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getSnapshots()));
        return modelRepository;
    }

    public static RepositoryPolicy fromSettingsRepositoryPolicy(hidden.org.apache.maven.settings.RepositoryPolicy settingsRepositoryPolicy) {
        RepositoryPolicy modelRepositoryPolicy = new RepositoryPolicy();
        if (settingsRepositoryPolicy != null) {
            modelRepositoryPolicy.setEnabled(settingsRepositoryPolicy.isEnabled());
            modelRepositoryPolicy.setUpdatePolicy(settingsRepositoryPolicy.getUpdatePolicy());
            modelRepositoryPolicy.setChecksumPolicy(settingsRepositoryPolicy.getChecksumPolicy());
        }
        return modelRepositoryPolicy;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        return MavenRepositorySystem.buildArtifactRepository(MavenRepositorySystem.fromSettingsRepository(repo));
    }

    public static ArtifactRepository buildArtifactRepository(hidden.org.apache.maven.model.Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            if (StringUtils.isEmpty(id)) {
                throw new InvalidRepositoryException("Repository identifier missing", "");
            }
            String url = repo.getUrl();
            if (StringUtils.isEmpty(url)) {
                throw new InvalidRepositoryException("URL missing for repository " + id, id);
            }
            ArtifactRepositoryPolicy snapshots = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getReleases());
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
        }
        return null;
    }

    public static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws Exception {
        ArtifactRepositoryLayout layout = this.layouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
    }

    private void checkLayout(String repositoryId, String layoutId, ArtifactRepositoryLayout layout) throws Exception {
        if (layout == null) {
            throw new Exception(String.format("Cannot find ArtifactRepositoryLayout instance for: %s %s", layoutId, repositoryId));
        }
    }

    public static ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        ArtifactRepository repository = repositoryLayout instanceof ArtifactRepositoryLayout2 ? ((ArtifactRepositoryLayout2)repositoryLayout).newMavenArtifactRepository(id, url, snapshots, releases) : new MavenArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        return repository;
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.XcreateArtifact(groupId, artifactId, version, scope, type, null, null);
    }

    private Artifact XcreateDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
    }

    private Artifact XcreateProjectArtifact(String groupId, String artifactId, String version) {
        return this.XcreateProjectArtifact(groupId, artifactId, version, null);
    }

    private Artifact XcreateParentArtifact(String groupId, String artifactId, String version) {
        return this.XcreateProjectArtifact(groupId, artifactId, version);
    }

    private Artifact XcreatePluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, "maven-plugin", null, "runtime", null);
    }

    private Artifact XcreateProjectArtifact(String groupId, String artifactId, String version, String scope) {
        return this.XcreateArtifact(groupId, artifactId, version, scope, "pom");
    }

    private Artifact XcreateExtensionArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, "jar", null, "runtime", null);
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier, String inheritedScope) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion(version);
        }
        return this.XcreateArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, false);
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("test".equals(scope) || "provided".equals(scope)) {
                return null;
            }
            if ("compile".equals(scope) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        if ("system".equals(scope)) {
            desiredScope = "system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type, classifier, handler, optional);
    }

    public ArtifactRepository createDefaultRemoteRepository(MavenExecutionRequest request) throws Exception {
        return this.createRepository("https://repo.maven.apache.org/maven2", "central", true, "daily", false, "daily", "warn");
    }

    public ArtifactRepository createRepository(String url, String repositoryId, boolean releases, String releaseUpdates, boolean snapshots, String snapshotUpdates, String checksumPolicy) throws Exception {
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(snapshots, snapshotUpdates, checksumPolicy);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(releases, releaseUpdates, checksumPolicy);
        return this.createArtifactRepository(repositoryId, url, "default", snapshotsPolicy, releasesPolicy);
    }

    public Set<String> getRepoIds(List<ArtifactRepository> repositories) {
        HashSet<String> repoIds = new HashSet<String>();
        if (repositories != null) {
            for (ArtifactRepository repository : repositories) {
                repoIds.add(repository.getId());
            }
        }
        return repoIds;
    }

    public ArtifactRepository createLocalRepository(MavenExecutionRequest request, File localRepository) throws Exception {
        return this.createRepository("file://" + localRepository.toURI().getRawPath(), "local", true, "always", true, "always", "ignore");
    }

    public static Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        String repoId = repository.getId();
        if (repoId != null && mirrors != null) {
            for (Mirror mirror : mirrors) {
                if (!repoId.equals(mirror.getMirrorOf()) || !MavenRepositorySystem.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
            for (Mirror mirror : mirrors) {
                if (!MavenRepositorySystem.matchPattern(repository, mirror.getMirrorOf()) || !MavenRepositorySystem.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(ArtifactRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && MavenRepositorySystem.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && !url.getProtocol().equals("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    static boolean matchesLayout(ArtifactRepository repository, Mirror mirror) {
        return MavenRepositorySystem.matchesLayout(RepositoryUtils.getLayout(repository), mirror.getMirrorOfLayouts());
    }

    static boolean matchesLayout(String repoLayout, String mirrorLayout) {
        boolean result = false;
        if (StringUtils.isEmpty(mirrorLayout) || WILDCARD.equals(mirrorLayout)) {
            result = true;
        } else if (mirrorLayout.equals(repoLayout)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorLayout.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoLayout)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoLayout)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }
}

