/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.execution;

import hidden.org.apache.maven.execution.MavenExecutionRequest;
import hidden.org.apache.maven.model.Profile;
import hidden.org.apache.maven.settings.Mirror;
import hidden.org.apache.maven.settings.Proxy;
import hidden.org.apache.maven.settings.RuntimeInfo;
import hidden.org.apache.maven.settings.Server;
import hidden.org.apache.maven.settings.Settings;
import hidden.org.apache.maven.settings.SettingsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class SettingsAdapter
extends Settings {
    private MavenExecutionRequest request;
    private RuntimeInfo runtimeInfo;

    public SettingsAdapter(MavenExecutionRequest request) {
        this.request = request;
        File userSettings = request.getUserSettingsFile();
        this.runtimeInfo = new RuntimeInfo(userSettings != null && userSettings.isFile() ? userSettings : null);
    }

    @Override
    public String getLocalRepository() {
        if (this.request.getLocalRepositoryPath() != null) {
            return this.request.getLocalRepositoryPath().getAbsolutePath();
        }
        return null;
    }

    @Override
    public boolean isInteractiveMode() {
        return this.request.isInteractiveMode();
    }

    @Override
    public boolean isOffline() {
        return this.request.isOffline();
    }

    @Override
    public List<Proxy> getProxies() {
        return this.request.getProxies();
    }

    @Override
    public List<Server> getServers() {
        return this.request.getServers();
    }

    @Override
    public List<Mirror> getMirrors() {
        return this.request.getMirrors();
    }

    @Override
    public List<hidden.org.apache.maven.settings.Profile> getProfiles() {
        ArrayList<hidden.org.apache.maven.settings.Profile> result = new ArrayList<hidden.org.apache.maven.settings.Profile>();
        for (Profile profile : this.request.getProfiles()) {
            result.add(SettingsUtils.convertToSettingsProfile(profile));
        }
        return result;
    }

    @Override
    public List<String> getActiveProfiles() {
        return this.request.getActiveProfiles();
    }

    @Override
    public List<String> getPluginGroups() {
        return this.request.getPluginGroups();
    }
}

