/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.lifecycle.internal;

import hidden.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.plugin.MojoExecution;
import hidden.org.apache.maven.plugin.descriptor.MojoDescriptor;
import hidden.org.apache.maven.project.MavenProject;
import java.util.ArrayList;
import java.util.List;

public class ExecutionPlanItem {
    private final MojoExecution mojoExecution;

    public ExecutionPlanItem(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    public static List<ExecutionPlanItem> createExecutionPlanItems(MavenProject mavenProject, List<MojoExecution> executions) {
        BuilderCommon.attachToThread(mavenProject);
        ArrayList<ExecutionPlanItem> result = new ArrayList<ExecutionPlanItem>();
        for (MojoExecution mojoExecution : executions) {
            result.add(new ExecutionPlanItem(mojoExecution));
        }
        return result;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public String getLifecyclePhase() {
        return this.mojoExecution.getLifecyclePhase();
    }

    public Plugin getPlugin() {
        MojoDescriptor mojoDescriptor = this.getMojoExecution().getMojoDescriptor();
        return mojoDescriptor.getPluginDescriptor().getPlugin();
    }

    public String toString() {
        return "ExecutionPlanItem{, mojoExecution=" + this.mojoExecution + '}' + super.toString();
    }
}

