/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.lifecycle.internal;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.ArtifactUtils;
import hidden.org.apache.maven.eventspy.internal.EventSpyDispatcher;
import hidden.org.apache.maven.execution.MavenSession;
import hidden.org.apache.maven.lifecycle.LifecycleExecutionException;
import hidden.org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import hidden.org.apache.maven.project.DefaultDependencyResolutionRequest;
import hidden.org.apache.maven.project.DependencyResolutionException;
import hidden.org.apache.maven.project.DependencyResolutionResult;
import hidden.org.apache.maven.project.MavenProject;
import hidden.org.apache.maven.project.ProjectDependenciesResolver;
import hidden.org.apache.maven.project.artifact.InvalidDependencyVersionException;
import hidden.org.eclipse.aether.graph.Dependency;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.graph.DependencyNode;
import hidden.org.eclipse.aether.util.filter.AndDependencyFilter;
import hidden.org.eclipse.aether.util.filter.ScopeDependencyFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;

@Named
public class LifecycleDependencyResolver {
    @Inject
    private ProjectDependenciesResolver dependenciesResolver;
    @Inject
    private Logger logger;
    @Inject
    private ProjectArtifactFactory artifactFactory;
    @Inject
    private EventSpyDispatcher eventSpyDispatcher;

    public LifecycleDependencyResolver() {
    }

    public LifecycleDependencyResolver(ProjectDependenciesResolver projectDependenciesResolver, Logger logger) {
        this.dependenciesResolver = projectDependenciesResolver;
        this.logger = logger;
    }

    public static List<MavenProject> getProjects(MavenProject project, MavenSession session, boolean aggregator) {
        if (aggregator) {
            return session.getProjects();
        }
        return Collections.singletonList(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveProjectDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<Artifact> projectArtifacts) throws LifecycleExecutionException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassRealm projectRealm = project.getClassRealm();
            if (projectRealm != null && projectRealm != tccl) {
                Thread.currentThread().setContextClassLoader(projectRealm);
            }
            if (project.getDependencyArtifacts() == null) {
                try {
                    project.setDependencyArtifacts(this.artifactFactory.createArtifacts(project));
                }
                catch (InvalidDependencyVersionException e) {
                    throw new LifecycleExecutionException(e);
                }
            }
            Set<Artifact> artifacts = this.getDependencies(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
            project.setResolvedArtifacts(artifacts);
            HashMap<String, Artifact> map = new HashMap<String, Artifact>();
            for (Artifact artifact : artifacts) {
                map.put(artifact.getDependencyConflictId(), artifact);
            }
            for (Artifact artifact : project.getDependencyArtifacts()) {
                Artifact resolved;
                if (artifact.getFile() != null || (resolved = (Artifact)map.get(artifact.getDependencyConflictId())) == null) continue;
                artifact.setFile(resolved.getFile());
                artifact.setDependencyTrail(resolved.getDependencyTrail());
                artifact.setResolvedVersion(resolved.getVersion());
                artifact.setResolved(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private Set<Artifact> getDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<Artifact> projectArtifacts) throws LifecycleExecutionException {
        DependencyResolutionResult result;
        if (scopesToCollect == null) {
            scopesToCollect = Collections.emptySet();
        }
        if (scopesToResolve == null) {
            scopesToResolve = Collections.emptySet();
        }
        if (scopesToCollect.isEmpty() && scopesToResolve.isEmpty()) {
            return new LinkedHashSet<Artifact>();
        }
        scopesToCollect = new HashSet<String>(scopesToCollect);
        scopesToCollect.addAll(scopesToResolve);
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(null, this.negate(scopesToCollect));
        DependencyFilter resolutionFilter = new ScopeDependencyFilter(null, this.negate(scopesToResolve));
        resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, resolutionFilter);
        resolutionFilter = AndDependencyFilter.newInstance(resolutionFilter, new ReactorDependencyFilter(projectArtifacts));
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, session.getRepositorySession());
            request.setResolutionFilter(resolutionFilter);
            this.eventSpyDispatcher.onEvent(request);
            result = this.dependenciesResolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            result = e.getResult();
            if (aggregating && this.areAllDependenciesInReactor(session.getProjects(), result.getUnresolvedDependencies())) {
                this.logger.warn("The following dependencies could not be resolved at this point of the build but seem to be part of the reactor:");
                for (Dependency dependency : result.getUnresolvedDependencies()) {
                    this.logger.warn("o " + dependency);
                }
                this.logger.warn("Try running the build up to the lifecycle phase \"package\"");
            }
            throw new LifecycleExecutionException(null, project, e);
        }
        this.eventSpyDispatcher.onEvent(result);
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
            RepositoryUtils.toArtifacts(artifacts, result.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), collectionFilter);
        }
        return artifacts;
    }

    private boolean areAllDependenciesInReactor(Collection<MavenProject> projects, Collection<Dependency> dependencies) {
        Set<String> projectKeys = this.getReactorProjectKeys(projects);
        for (Dependency dependency : dependencies) {
            hidden.org.eclipse.aether.artifact.Artifact a = dependency.getArtifact();
            String key = ArtifactUtils.key(a.getGroupId(), a.getArtifactId(), a.getVersion());
            if (projectKeys.contains(key)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getReactorProjectKeys(Collection<MavenProject> projects) {
        HashSet<String> projectKeys = new HashSet<String>(projects.size() * 2);
        for (MavenProject project : projects) {
            String key = ArtifactUtils.key(project.getGroupId(), project.getArtifactId(), project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    private Collection<String> negate(Collection<String> scopes) {
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, "system", "compile", "provided", "runtime", "test");
        for (String scope : scopes) {
            if ("compile".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                continue;
            }
            if ("runtime".equals(scope)) {
                result.remove("compile");
                result.remove("runtime");
                continue;
            }
            if ("compile+runtime".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("provided");
                result.remove("runtime");
                continue;
            }
            if ("runtime+system".equals(scope)) {
                result.remove("compile");
                result.remove("system");
                result.remove("runtime");
                continue;
            }
            if (!"test".equals(scope)) continue;
            result.clear();
        }
        return result;
    }

    private static class ReactorDependencyFilter
    implements DependencyFilter {
        private Set<String> keys = new HashSet<String>();

        public ReactorDependencyFilter(Collection<Artifact> artifacts) {
            for (Artifact artifact : artifacts) {
                String key = ArtifactUtils.key(artifact);
                this.keys.add(key);
            }
        }

        @Override
        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            Dependency dependency = node.getDependency();
            if (dependency != null) {
                hidden.org.eclipse.aether.artifact.Artifact a = dependency.getArtifact();
                String key = ArtifactUtils.key(a.getGroupId(), a.getArtifactId(), a.getVersion());
                return !this.keys.contains(key);
            }
            return false;
        }
    }
}

