/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.lifecycle.internal;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.execution.BuildSuccess;
import hidden.org.apache.maven.execution.ExecutionEvent;
import hidden.org.apache.maven.execution.MavenSession;
import hidden.org.apache.maven.execution.ProjectExecutionEvent;
import hidden.org.apache.maven.execution.ProjectExecutionListener;
import hidden.org.apache.maven.lifecycle.MavenExecutionPlan;
import hidden.org.apache.maven.lifecycle.internal.CompoundProjectExecutionListener;
import hidden.org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import hidden.org.apache.maven.lifecycle.internal.MojoExecutor;
import hidden.org.apache.maven.lifecycle.internal.ReactorContext;
import hidden.org.apache.maven.lifecycle.internal.TaskSegment;
import hidden.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import hidden.org.apache.maven.plugin.MojoExecution;
import hidden.org.apache.maven.project.MavenProject;
import hidden.org.apache.maven.session.scope.internal.SessionScope;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=LifecycleModuleBuilder.class)
public class LifecycleModuleBuilder {
    @Requirement
    private MojoExecutor mojoExecutor;
    @Requirement
    private BuilderCommon builderCommon;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    private ProjectExecutionListener projectExecutionListener;
    @Requirement
    private List<ProjectExecutionListener> projectExecutionListeners;
    @Requirement
    private SessionScope sessionScope;

    public void setProjectExecutionListeners(List<ProjectExecutionListener> listeners) {
        this.projectExecutionListeners = listeners;
        this.projectExecutionListener = new CompoundProjectExecutionListener(listeners);
    }

    public void buildProject(MavenSession session, ReactorContext reactorContext, MavenProject currentProject, TaskSegment taskSegment) {
        this.buildProject(session, session, reactorContext, currentProject, taskSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildProject(MavenSession session, MavenSession rootSession, ReactorContext reactorContext, MavenProject currentProject, TaskSegment taskSegment) {
        session.setCurrentProject(currentProject);
        long buildStartTime = System.currentTimeMillis();
        this.sessionScope.enter(reactorContext.getSessionScopeMemento());
        this.sessionScope.seed(MavenSession.class, session);
        try {
            if (reactorContext.getReactorBuildStatus().isHaltedOrBlacklisted(currentProject)) {
                this.eventCatapult.fire(ExecutionEvent.Type.ProjectSkipped, session, null);
                return;
            }
            BuilderCommon.attachToThread(currentProject);
            this.projectExecutionListener.beforeProjectExecution(new ProjectExecutionEvent(session, currentProject));
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectStarted, session, null);
            MavenExecutionPlan executionPlan = this.builderCommon.resolveBuildPlan(session, currentProject, taskSegment, new HashSet<Artifact>());
            List<MojoExecution> mojoExecutions = executionPlan.getMojoExecutions();
            this.projectExecutionListener.beforeProjectLifecycleExecution(new ProjectExecutionEvent(session, currentProject, mojoExecutions));
            this.mojoExecutor.execute(session, mojoExecutions, reactorContext.getProjectIndex());
            long buildEndTime = System.currentTimeMillis();
            this.projectExecutionListener.afterProjectExecutionSuccess(new ProjectExecutionEvent(session, currentProject, mojoExecutions));
            reactorContext.getResult().addBuildSummary(new BuildSuccess(currentProject, buildEndTime - buildStartTime));
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectSucceeded, session, null);
        }
        catch (Throwable t) {
            this.builderCommon.handleBuildError(reactorContext, rootSession, session, currentProject, t, buildStartTime);
            this.projectExecutionListener.afterProjectExecutionFailure(new ProjectExecutionEvent(session, currentProject, t));
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        finally {
            this.sessionScope.exit();
            session.setCurrentProject(null);
            Thread.currentThread().setContextClassLoader(reactorContext.getOriginalContextClassLoader());
        }
    }
}

