/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.model.plugin;

import hidden.org.apache.maven.model.Build;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.model.PluginManagement;
import hidden.org.apache.maven.model.ReportPlugin;
import hidden.org.apache.maven.model.ReportSet;
import hidden.org.apache.maven.model.Reporting;
import hidden.org.apache.maven.model.building.ModelBuildingRequest;
import hidden.org.apache.maven.model.building.ModelProblem;
import hidden.org.apache.maven.model.building.ModelProblemCollector;
import hidden.org.apache.maven.model.building.ModelProblemCollectorRequest;
import hidden.org.apache.maven.model.plugin.ReportingConverter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ReportingConverter.class)
public class DefaultReportingConverter
implements ReportingConverter {
    @Override
    public void convertReporting(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Xpp3Dom reportPlugins;
        Xpp3Dom configuration;
        Plugin sitePlugin;
        Reporting reporting = model.getReporting();
        if (reporting == null) {
            return;
        }
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if ((sitePlugin = this.findSitePlugin(build)) == null) {
            sitePlugin = new Plugin();
            sitePlugin.setArtifactId("maven-site-plugin");
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement == null) {
                pluginManagement = new PluginManagement();
                build.setPluginManagement(pluginManagement);
            }
            pluginManagement.addPlugin(sitePlugin);
        }
        if ((configuration = (Xpp3Dom)sitePlugin.getConfiguration()) == null) {
            configuration = new Xpp3Dom("configuration");
            sitePlugin.setConfiguration(configuration);
        }
        if ((reportPlugins = configuration.getChild("reportPlugins")) != null) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.BASE).setMessage("Reporting configuration should be done in <reporting> section, not in maven-site-plugin <configuration> as reportPlugins parameter.").setLocation(sitePlugin.getLocation("configuration")));
            return;
        }
        if (configuration.getChild("outputDirectory") == null) {
            this.addDom(configuration, "outputDirectory", reporting.getOutputDirectory());
        }
        reportPlugins = new Xpp3Dom("reportPlugins");
        configuration.addChild(reportPlugins);
        boolean hasMavenProjectInfoReportsPlugin = false;
        for (ReportPlugin plugin : reporting.getPlugins()) {
            Xpp3Dom reportPlugin = this.convert(plugin);
            reportPlugins.addChild(reportPlugin);
            if (reporting.isExcludeDefaults() || hasMavenProjectInfoReportsPlugin || !"hidden.org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-project-info-reports-plugin".equals(plugin.getArtifactId())) continue;
            hasMavenProjectInfoReportsPlugin = true;
        }
        if (!reporting.isExcludeDefaults() && !hasMavenProjectInfoReportsPlugin) {
            Xpp3Dom dom = new Xpp3Dom("reportPlugin");
            this.addDom(dom, "groupId", "hidden.org.apache.maven.plugins");
            this.addDom(dom, "artifactId", "maven-project-info-reports-plugin");
            reportPlugins.addChild(dom);
        }
    }

    private Plugin findSitePlugin(Build build) {
        for (Plugin plugin : build.getPlugins()) {
            if (!this.isSitePlugin(plugin)) continue;
            return plugin;
        }
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                if (!this.isSitePlugin(plugin)) continue;
                return plugin;
            }
        }
        return null;
    }

    private boolean isSitePlugin(Plugin plugin) {
        return "maven-site-plugin".equals(plugin.getArtifactId()) && "hidden.org.apache.maven.plugins".equals(plugin.getGroupId());
    }

    private Xpp3Dom convert(ReportPlugin plugin) {
        Xpp3Dom dom = new Xpp3Dom("reportPlugin");
        this.addDom(dom, "groupId", plugin.getGroupId());
        this.addDom(dom, "artifactId", plugin.getArtifactId());
        this.addDom(dom, "version", plugin.getVersion());
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration != null) {
            configuration = new Xpp3Dom(configuration);
            dom.addChild(configuration);
        }
        if (!plugin.getReportSets().isEmpty()) {
            Xpp3Dom reportSets = new Xpp3Dom("reportSets");
            for (ReportSet reportSet : plugin.getReportSets()) {
                Xpp3Dom rs = this.convert(reportSet);
                reportSets.addChild(rs);
            }
            dom.addChild(reportSets);
        }
        return dom;
    }

    private Xpp3Dom convert(ReportSet reportSet) {
        Xpp3Dom dom = new Xpp3Dom("reportSet");
        this.addDom(dom, "id", reportSet.getId());
        Xpp3Dom configuration = (Xpp3Dom)reportSet.getConfiguration();
        if (configuration != null) {
            configuration = new Xpp3Dom(configuration);
            dom.addChild(configuration);
        }
        if (!reportSet.getReports().isEmpty()) {
            Xpp3Dom reports = new Xpp3Dom("reports");
            for (String report : reportSet.getReports()) {
                this.addDom(reports, "report", report);
            }
            dom.addChild(reports);
        }
        return dom;
    }

    private void addDom(Xpp3Dom parent, String childName, String childValue) {
        if (StringUtils.isNotEmpty(childValue)) {
            parent.addChild(this.newDom(childName, childValue));
        }
    }

    private Xpp3Dom newDom(String name, String value) {
        Xpp3Dom dom = new Xpp3Dom(name);
        dom.setValue(value);
        return dom;
    }
}

