/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.plugin;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.plugin.descriptor.PluginDescriptor;
import java.util.ArrayList;
import java.util.List;

public class MavenPluginValidator {
    private final Artifact pluginArtifact;
    private List<String> errors = new ArrayList<String>();
    private boolean firstDescriptor = true;

    public MavenPluginValidator(Artifact pluginArtifact) {
        this.pluginArtifact = pluginArtifact;
    }

    public void validate(PluginDescriptor pluginDescriptor) {
        if (!this.firstDescriptor) {
            return;
        }
        this.firstDescriptor = false;
        if (!this.pluginArtifact.getGroupId().equals(pluginDescriptor.getGroupId())) {
            this.errors.add("Plugin's descriptor contains the wrong group ID: " + pluginDescriptor.getGroupId());
        }
        if (!this.pluginArtifact.getArtifactId().equals(pluginDescriptor.getArtifactId())) {
            this.errors.add("Plugin's descriptor contains the wrong artifact ID: " + pluginDescriptor.getArtifactId());
        }
        if (!this.pluginArtifact.getBaseVersion().equals(pluginDescriptor.getVersion())) {
            this.errors.add("Plugin's descriptor contains the wrong version: " + pluginDescriptor.getVersion());
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

