/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import hidden.org.apache.maven.artifact.resolver.CyclicDependencyException;
import hidden.org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import hidden.org.apache.maven.repository.MetadataGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MetadataResolutionResult {
    private Artifact originatingArtifact;
    private List<Artifact> missingArtifacts;
    private List<Exception> exceptions;
    private List<Exception> versionRangeViolations;
    private List<ArtifactResolutionException> metadataResolutionExceptions;
    private List<CyclicDependencyException> circularDependencyExceptions;
    private List<ArtifactResolutionException> errorArtifactExceptions;
    private List<ArtifactRepository> repositories;
    private Set<Artifact> requestedArtifacts;
    private Set<Artifact> artifacts;
    private MetadataGraph dirtyTree;
    private MetadataGraph resolvedTree;
    private MetadataGraph resolvedGraph;

    public Artifact getOriginatingArtifact() {
        return this.originatingArtifact;
    }

    public MetadataResolutionResult ListOriginatingArtifact(Artifact originatingArtifact) {
        this.originatingArtifact = originatingArtifact;
        return this;
    }

    public void addArtifact(Artifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = new LinkedHashSet<Artifact>();
        }
        this.artifacts.add(artifact);
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void addRequestedArtifact(Artifact artifact) {
        if (this.requestedArtifacts == null) {
            this.requestedArtifacts = new LinkedHashSet<Artifact>();
        }
        this.requestedArtifacts.add(artifact);
    }

    public Set<Artifact> getRequestedArtifacts() {
        return this.requestedArtifacts;
    }

    public boolean hasMissingArtifacts() {
        return this.missingArtifacts != null && !this.missingArtifacts.isEmpty();
    }

    public List<Artifact> getMissingArtifacts() {
        return this.missingArtifacts == null ? Collections.emptyList() : this.missingArtifacts;
    }

    public MetadataResolutionResult addMissingArtifact(Artifact artifact) {
        this.missingArtifacts = this.initList(this.missingArtifacts);
        this.missingArtifacts.add(artifact);
        return this;
    }

    public MetadataResolutionResult setUnresolvedArtifacts(List<Artifact> unresolvedArtifacts) {
        this.missingArtifacts = unresolvedArtifacts;
        return this;
    }

    public boolean hasExceptions() {
        return this.exceptions != null && !this.exceptions.isEmpty();
    }

    public List<Exception> getExceptions() {
        return this.exceptions == null ? Collections.emptyList() : this.exceptions;
    }

    public boolean hasVersionRangeViolations() {
        return this.versionRangeViolations != null;
    }

    public MetadataResolutionResult addVersionRangeViolation(Exception e) {
        this.versionRangeViolations = this.initList(this.versionRangeViolations);
        this.versionRangeViolations.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add(e);
        return this;
    }

    public OverConstrainedVersionException getVersionRangeViolation(int i) {
        return (OverConstrainedVersionException)this.versionRangeViolations.get(i);
    }

    public List<Exception> getVersionRangeViolations() {
        return this.versionRangeViolations == null ? Collections.emptyList() : this.versionRangeViolations;
    }

    public boolean hasMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions != null;
    }

    public MetadataResolutionResult addMetadataResolutionException(ArtifactResolutionException e) {
        this.metadataResolutionExceptions = this.initList(this.metadataResolutionExceptions);
        this.metadataResolutionExceptions.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add(e);
        return this;
    }

    public ArtifactResolutionException getMetadataResolutionException(int i) {
        return this.metadataResolutionExceptions.get(i);
    }

    public List<ArtifactResolutionException> getMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions == null ? Collections.emptyList() : this.metadataResolutionExceptions;
    }

    public boolean hasErrorArtifactExceptions() {
        return this.errorArtifactExceptions != null;
    }

    public MetadataResolutionResult addError(Exception e) {
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add(e);
        return this;
    }

    public List<ArtifactResolutionException> getErrorArtifactExceptions() {
        if (this.errorArtifactExceptions == null) {
            return Collections.emptyList();
        }
        return this.errorArtifactExceptions;
    }

    public boolean hasCircularDependencyExceptions() {
        return this.circularDependencyExceptions != null;
    }

    public MetadataResolutionResult addCircularDependencyException(CyclicDependencyException e) {
        this.circularDependencyExceptions = this.initList(this.circularDependencyExceptions);
        this.circularDependencyExceptions.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add(e);
        return this;
    }

    public CyclicDependencyException getCircularDependencyException(int i) {
        return this.circularDependencyExceptions.get(i);
    }

    public List<CyclicDependencyException> getCircularDependencyExceptions() {
        if (this.circularDependencyExceptions == null) {
            return Collections.emptyList();
        }
        return this.circularDependencyExceptions;
    }

    public List<ArtifactRepository> getRepositories() {
        if (this.repositories == null) {
            return Collections.emptyList();
        }
        return this.repositories;
    }

    public MetadataResolutionResult setRepositories(List<ArtifactRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    private <T> List<T> initList(List<T> l) {
        if (l == null) {
            return new ArrayList();
        }
        return l;
    }

    public String toString() {
        if (this.artifacts == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        int i = 1;
        sb.append("---------\n");
        sb.append(this.artifacts.size()).append('\n');
        for (Artifact a : this.artifacts) {
            sb.append(i).append(' ').append(a).append('\n');
            ++i;
        }
        sb.append("---------\n");
        return sb.toString();
    }

    public MetadataGraph getResolvedTree() {
        return this.resolvedTree;
    }

    public void setResolvedTree(MetadataGraph resolvedTree) {
        this.resolvedTree = resolvedTree;
    }
}

