/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.shared.utils.cli.shell;

import hidden.org.apache.maven.shared.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Shell
implements Cloneable {
    private static final char[] DEFAULT_QUOTING_TRIGGER_CHARS = new char[]{' '};
    private String shellCommand;
    private final List<String> shellArgs = new ArrayList<String>();
    private boolean quotedArgumentsEnabled = true;
    private String executable;
    private String workingDir;
    private boolean quotedExecutableEnabled = true;
    private boolean singleQuotedArgumentEscaped = false;
    private boolean singleQuotedExecutableEscaped = false;
    private char argQuoteDelimiter = (char)34;
    private char exeQuoteDelimiter = (char)34;

    void setShellCommand(String shellCommand) {
        this.shellCommand = shellCommand;
    }

    String getShellCommand() {
        return this.shellCommand;
    }

    void setShellArgs(String[] shellArgs) {
        this.shellArgs.clear();
        this.shellArgs.addAll(Arrays.asList(shellArgs));
    }

    String[] getShellArgs() {
        if (this.shellArgs == null || this.shellArgs.isEmpty()) {
            return null;
        }
        return this.shellArgs.toArray(new String[this.shellArgs.size()]);
    }

    List<String> getCommandLine(String executableParameter, String ... argumentsParameter) {
        return this.getRawCommandLine(executableParameter, argumentsParameter);
    }

    List<String> getRawCommandLine(String executableParameter, String ... argumentsParameter) {
        ArrayList<String> commandLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (executableParameter != null) {
            String preamble = this.getExecutionPreamble();
            if (preamble != null) {
                sb.append(preamble);
            }
            if (this.isQuotedExecutableEnabled()) {
                char[] escapeChars = this.getEscapeChars(this.isSingleQuotedExecutableEscaped(), this.isDoubleQuotedExecutableEscaped());
                sb.append(StringUtils.quoteAndEscape(this.getExecutable(), this.getExecutableQuoteDelimiter(), escapeChars, this.getQuotingTriggerChars(), '\\', false));
            } else {
                sb.append(this.getExecutable());
            }
        }
        for (String argument : argumentsParameter) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (this.isQuotedArgumentsEnabled()) {
                char[] escapeChars = this.getEscapeChars(this.isSingleQuotedArgumentEscaped(), this.isDoubleQuotedArgumentEscaped());
                sb.append(StringUtils.quoteAndEscape(argument, this.getArgumentQuoteDelimiter(), escapeChars, this.getQuotingTriggerChars(), '\\', false));
                continue;
            }
            sb.append(argument);
        }
        commandLine.add(sb.toString());
        return commandLine;
    }

    char[] getQuotingTriggerChars() {
        return DEFAULT_QUOTING_TRIGGER_CHARS;
    }

    String getExecutionPreamble() {
        return null;
    }

    char[] getEscapeChars(boolean includeSingleQuote, boolean includeDoubleQuote) {
        StringBuilder buf = new StringBuilder(2);
        if (includeSingleQuote) {
            buf.append('\'');
        }
        if (includeDoubleQuote) {
            buf.append('\"');
        }
        char[] result = new char[buf.length()];
        buf.getChars(0, buf.length(), result, 0);
        return result;
    }

    protected boolean isDoubleQuotedArgumentEscaped() {
        return false;
    }

    protected boolean isSingleQuotedArgumentEscaped() {
        return this.singleQuotedArgumentEscaped;
    }

    boolean isDoubleQuotedExecutableEscaped() {
        return false;
    }

    boolean isSingleQuotedExecutableEscaped() {
        return this.singleQuotedExecutableEscaped;
    }

    void setArgumentQuoteDelimiter(char argQuoteDelimiterParameter) {
        this.argQuoteDelimiter = argQuoteDelimiterParameter;
    }

    char getArgumentQuoteDelimiter() {
        return this.argQuoteDelimiter;
    }

    void setExecutableQuoteDelimiter(char exeQuoteDelimiterParameter) {
        this.exeQuoteDelimiter = exeQuoteDelimiterParameter;
    }

    char getExecutableQuoteDelimiter() {
        return this.exeQuoteDelimiter;
    }

    public List<String> getShellCommandLine(String ... arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.getShellCommand() != null) {
            commandLine.add(this.getShellCommand());
        }
        if (this.getShellArgs() != null) {
            commandLine.addAll(this.getShellArgsList());
        }
        commandLine.addAll(this.getCommandLine(this.getExecutable(), arguments));
        return commandLine;
    }

    List<String> getShellArgsList() {
        return this.shellArgs;
    }

    public void setQuotedArgumentsEnabled(boolean quotedArgumentsEnabled) {
        this.quotedArgumentsEnabled = quotedArgumentsEnabled;
    }

    boolean isQuotedArgumentsEnabled() {
        return this.quotedArgumentsEnabled;
    }

    void setQuotedExecutableEnabled(boolean quotedExecutableEnabled) {
        this.quotedExecutableEnabled = quotedExecutableEnabled;
    }

    boolean isQuotedExecutableEnabled() {
        return this.quotedExecutableEnabled;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setWorkingDirectory(String path) {
        if (path != null) {
            this.workingDir = path;
        }
    }

    public void setWorkingDirectory(File workingDirectory) {
        if (workingDirectory != null) {
            this.workingDir = workingDirectory.getAbsolutePath();
        }
    }

    public File getWorkingDirectory() {
        return this.workingDir == null ? null : new File(this.workingDir);
    }

    String getWorkingDirectoryAsString() {
        return this.workingDir;
    }

    public Object clone() {
        throw new RuntimeException("Do we ever clone this?");
    }

    void setSingleQuotedArgumentEscaped(boolean singleQuotedArgumentEscaped) {
        this.singleQuotedArgumentEscaped = singleQuotedArgumentEscaped;
    }

    void setSingleQuotedExecutableEscaped(boolean singleQuotedExecutableEscaped) {
        this.singleQuotedExecutableEscaped = singleQuotedExecutableEscaped;
    }
}

