/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import hidden.org.apache.maven.settings.Settings;
import hidden.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import hidden.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import hidden.org.apache.maven.settings.building.SettingsBuildingException;
import hidden.org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import hidden.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import hidden.org.apache.maven.settings.crypto.SettingsDecrypter;
import hidden.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import hidden.org.eclipse.aether.DefaultRepositorySystemSession;
import hidden.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.reflect.Field;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.springframework.boot.loader.thin.MavenSettings;

public class MavenSettingsReader {
    private static final Logger log = LoggerFactory.getLogger(MavenSettingsReader.class);
    private final String homeDir;

    public MavenSettingsReader() {
        this(null);
    }

    public MavenSettingsReader(String homeDir) {
        if (homeDir == null) {
            homeDir = System.getProperty("settings.home", System.getProperty("user.home"));
        }
        this.homeDir = homeDir;
    }

    public MavenSettings readSettings() {
        Settings settings = this.loadSettings();
        SettingsDecryptionResult decrypted = this.decryptSettings(settings);
        if (!decrypted.getProblems().isEmpty()) {
            log.error("Maven settings decryption failed. Some Maven repositories may be inaccessible");
        }
        return new MavenSettings(settings, decrypted);
    }

    public static void applySettings(MavenSettings settings, DefaultRepositorySystemSession session) {
        if (settings.getLocalRepository() != null) {
            try {
                session.setLocalRepositoryManager(new SimpleLocalRepositoryManagerFactory().newInstance(session, new LocalRepository(settings.getLocalRepository())));
            }
            catch (NoLocalRepositoryManagerException e) {
                throw new IllegalStateException("Cannot set local repository to " + settings.getLocalRepository(), e);
            }
        }
        session.setOffline(settings.getOffline());
        session.setMirrorSelector(settings.getMirrorSelector());
        session.setAuthenticationSelector(settings.getAuthenticationSelector());
        session.setProxySelector(settings.getProxySelector());
    }

    private Settings loadSettings() {
        File settingsFile = new File(this.homeDir, ".m2/settings.xml");
        if (settingsFile.exists()) {
            log.info("Reading settings from: " + settingsFile);
        } else {
            log.info("No settings found at: " + settingsFile);
            String home = System.getProperty("user.home");
            if (!new File(home).getAbsolutePath().equals(new File(this.homeDir).getAbsolutePath()) && (settingsFile = new File(home, ".m2/settings.xml")).exists()) {
                log.info("Reading settings from: " + settingsFile);
            }
        }
        return this.loadSettings(settingsFile);
    }

    private Settings loadSettings(File settingsFile) {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(settingsFile);
        request.setSystemProperties(System.getProperties());
        try {
            return new DefaultSettingsBuilderFactory().newInstance().build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException("Failed to build settings from " + settingsFile, ex);
        }
    }

    private SettingsDecryptionResult decryptSettings(Settings settings) {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(settings);
        return this.createSettingsDecrypter().decrypt(request);
    }

    private SettingsDecrypter createSettingsDecrypter() {
        DefaultSettingsDecrypter settingsDecrypter = new DefaultSettingsDecrypter();
        this.setField(DefaultSettingsDecrypter.class, "securityDispatcher", settingsDecrypter, new SpringBootSecDispatcher());
        return settingsDecrypter;
    }

    private void setField(Class<?> sourceClass, String fieldName, Object target, Object value) {
        try {
            Field field = sourceClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to set field '" + fieldName + "' on '" + target + "'", ex);
        }
    }

    private class SpringBootSecDispatcher
    extends DefaultSecDispatcher {
        private static final String SECURITY_XML = ".m2/settings-security.xml";

        SpringBootSecDispatcher() {
            File file = new File(MavenSettingsReader.this.homeDir, SECURITY_XML);
            this._configurationFile = file.getAbsolutePath();
            try {
                this._cipher = new DefaultPlexusCipher();
            }
            catch (PlexusCipherException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

