/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.experimental.maven.ThinJarMojo;

@Mojo(name="properties", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PropertiesMojo
extends ThinJarMojo {
    @Parameter(defaultValue="src/main/resources/META-INF", required=true, property="thin.output")
    private File outputDirectory;
    @Parameter(property="thin.compute", defaultValue="true", required=true)
    private boolean compute;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        File deployable = this.project.getArtifact().getFile();
        this.getLog().info((CharSequence)("Calculating properties for: " + deployable));
        Properties props = new Properties();
        try {
            File target = new File(this.outputDirectory, "thin.properties");
            if (target.exists()) {
                props.load(new FileInputStream(target));
            }
            props.setProperty("computed", "" + this.compute);
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.startsWith("dependencies.")) {
                    props.remove(key);
                }
                if (!key.startsWith("boms.")) continue;
                props.remove(key);
            }
            this.boms(this.project, props);
            Set artifacts = this.compute ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                if (!"runtime".equals(artifact.getScope()) && !"compile".equals(artifact.getScope())) continue;
                props.setProperty("dependencies." + artifact.getArtifactId(), this.coordinates(artifact));
            }
            props.store(new FileOutputStream(target), "Enhanced by thin jar maven plugin");
            this.getLog().info((CharSequence)"Saved thin.properties");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot calculate dependencies for: " + deployable, e);
        }
        this.getLog().info((CharSequence)("Properties ready in: " + this.outputDirectory));
    }

    private void boms(MavenProject project, Properties props) {
        while (project != null) {
            String artifactId = project.getArtifactId();
            if (this.isBom(artifactId)) {
                props.setProperty("boms." + artifactId, this.coordinates(project.getArtifact(), true));
            }
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                if (!"import".equals(dependency.getScope())) continue;
                props.setProperty("boms." + dependency.getArtifactId(), this.coordinates(dependency));
            }
            project = project.getParent();
        }
    }

    private boolean isBom(String artifactId) {
        return artifactId.endsWith("-dependencies") || artifactId.endsWith("-bom");
    }

    private String coordinates(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
    }

    private String coordinates(Artifact dependency) {
        return this.coordinates(dependency, this.compute);
    }

    private String coordinates(Artifact dependency, boolean withVersion) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + (withVersion ? ":" + dependency.getVersion() : "");
    }
}

