/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.springframework.boot.experimental.maven.ThinJarMojo;

@Mojo(name="resolve", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresDependencyCollection=ResolutionScope.NONE)
public class ResolveMojo
extends ThinJarMojo {
    @Parameter(defaultValue="${project.build.directory}/thin/root", required=true, property="thin.outputDirectory")
    private File outputDirectory;
    @Parameter
    private List<Dependency> deployables;
    @Parameter(property="thin.includeSelf")
    private boolean includeSelf = true;
    @Parameter(property="thin.unpack")
    private boolean unpack = false;
    @Component
    protected ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.outputDirectory.mkdirs();
        ArrayList<File> deployables = new ArrayList<File>();
        File file = this.project.getArtifact().getFile();
        if (file != null && this.includeSelf && !this.unpack) {
            deployables.add(file);
        }
        if (this.deployables != null) {
            for (Dependency dependency : this.deployables) {
                File resolved;
                if (dependency == null || (resolved = this.resolveFile(dependency)) == null) continue;
                deployables.add(resolved);
            }
        }
        for (File file2 : deployables) {
            this.getLog().info((CharSequence)("Deploying: " + file2));
            try {
                this.getLog().info((CharSequence)("Copying: " + file2.getName() + " to " + this.outputDirectory));
                FileUtils.copyFile((File)file2, (File)new File(this.outputDirectory, file2.getName()));
                this.runWithForkedJvm(file2, this.outputDirectory, new String[0]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot locate deployable " + file2, e);
            }
        }
        if (this.includeSelf && this.unpack) {
            try {
                this.runWithForkedJvm(file, this.outputDirectory, new String[0]);
                UnArchiver archiver = this.archiverManager.getUnArchiver(file);
                archiver.setSourceFile(file);
                archiver.setDestDirectory(this.outputDirectory);
                archiver.setOverwrite(true);
                archiver.setUseJvmChmod(true);
                archiver.extract();
            }
            catch (NoSuchArchiverException e) {
                throw new MojoExecutionException("Cannot unpack artifact " + file, (Exception)((Object)e));
            }
        }
        this.getLog().info((CharSequence)("All deployables and dependencies ready in: " + this.outputDirectory));
    }
}

