/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.RunProcess;

public abstract class ThinJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip;
    @Component
    private RepositorySystem repositorySystem;
    private static final int EXIT_CODE_SIGINT = 130;

    protected File resolveFile(Dependency deployable) {
        Artifact artifact = this.repositorySystem.createArtifactWithClassifier(deployable.getGroupId(), deployable.getArtifactId(), deployable.getVersion(), deployable.getType(), deployable.getClassifier());
        artifact = (Artifact)this.repositorySystem.resolve(this.getRequest(artifact)).getArtifacts().iterator().next();
        return artifact.getFile();
    }

    protected void runWithForkedJvm(File archive, File workingDirectory, String ... args) throws MojoExecutionException {
        try {
            String localRepo = this.settings.getLocalRepository();
            ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(new JavaExecutable().toString(), "-Dmaven.repo.local=" + localRepo, "-Dthin.dryrun", "-Dthin.root=.", "-jar", archive.getAbsolutePath()));
            if (localRepo != null) {
                cmd.add(1, "-Dmaven.repo.local=" + localRepo);
            }
            RunProcess runProcess = new RunProcess(workingDirectory, cmd.toArray(new String[0]));
            Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller(runProcess)));
            this.getLog().debug((CharSequence)("Running: " + archive));
            int exitCode = runProcess.run(true, args);
            if (exitCode == 0 || exitCode == 130) {
                return;
            }
            throw new MojoExecutionException("Application finished with exit code: " + exitCode);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    private ArtifactResolutionRequest getRequest(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveTransitively(false);
        return request;
    }

    private static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        private RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

