/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.MBeanServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.ExposeExcludePropertyEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.DefaultEndpointObjectNameFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.ExposableJmxEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.JacksonJmxOperationResponseMapper;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointExporter;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperationResponseMapper;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

@AutoConfigureAfter(value={JmxAutoConfiguration.class})
@EnableConfigurationProperties(value={JmxEndpointProperties.class})
public class JmxEndpointAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final JmxEndpointProperties properties;

    public JmxEndpointAutoConfiguration(ApplicationContext applicationContext, JmxEndpointProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={JmxEndpointsSupplier.class})
    public JmxEndpointDiscoverer jmxAnnotationEndpointDiscoverer(ParameterValueMapper parameterValueMapper, ObjectProvider<Collection<OperationInvokerAdvisor>> invokerAdvisors, ObjectProvider<Collection<EndpointFilter<ExposableJmxEndpoint>>> filters) {
        return new JmxEndpointDiscoverer(this.applicationContext, parameterValueMapper, (Collection)invokerAdvisors.getIfAvailable(Collections::emptyList), (Collection)filters.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConditionalOnSingleCandidate(value=MBeanServer.class)
    public JmxEndpointExporter jmxMBeanExporter(MBeanServer mBeanServer, ObjectProvider<ObjectMapper> objectMapper, JmxEndpointsSupplier jmxEndpointsSupplier) {
        String contextId = ObjectUtils.getIdentityHexString((Object)this.applicationContext);
        DefaultEndpointObjectNameFactory objectNameFactory = new DefaultEndpointObjectNameFactory(this.properties, mBeanServer, contextId);
        JacksonJmxOperationResponseMapper responseMapper = new JacksonJmxOperationResponseMapper((ObjectMapper)objectMapper.getIfAvailable());
        return new JmxEndpointExporter(mBeanServer, (EndpointObjectNameFactory)objectNameFactory, (JmxOperationResponseMapper)responseMapper, jmxEndpointsSupplier.getEndpoints());
    }

    @Bean
    public ExposeExcludePropertyEndpointFilter<ExposableJmxEndpoint> jmxIncludeExcludePropertyEndpointFilter() {
        Set<String> expose = this.properties.getExpose();
        Set<String> exclude = this.properties.getExclude();
        return new ExposeExcludePropertyEndpointFilter<ExposableJmxEndpoint>(ExposableJmxEndpoint.class, expose, exclude, "*");
    }
}

