/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.atlas;

import com.netflix.spectator.atlas.AtlasConfig;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import org.springframework.boot.actuate.autoconfigure.metrics.export.atlas.AtlasProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.atlas.AtlasPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AtlasMeterRegistry.class})
@EnableConfigurationProperties(value={AtlasProperties.class})
public class AtlasExportConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AtlasConfig.class})
    public AtlasConfig atlasConfig(AtlasProperties atlasProperties) {
        return new AtlasPropertiesConfigAdapter(atlasProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.export.atlas.enabled"}, matchIfMissing=true)
    public AtlasMeterRegistry atlasMeterRegistry(AtlasConfig atlasConfig, Clock clock) {
        return new AtlasMeterRegistry(atlasConfig, clock);
    }
}

