/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.ganglia;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.ganglia.GangliaConfig;
import io.micrometer.ganglia.GangliaMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ganglia.GangliaProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ganglia.GangliaPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GangliaMeterRegistry.class})
@EnableConfigurationProperties(value={GangliaProperties.class})
public class GangliaExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GangliaConfig gangliaConfig(GangliaProperties gangliaProperties) {
        return new GangliaPropertiesConfigAdapter(gangliaProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.export.ganglia.enabled"}, matchIfMissing=true)
    public GangliaMeterRegistry gangliaMeterRegistry(GangliaConfig gangliaConfig, HierarchicalNameMapper nameMapper, Clock clock) {
        return new GangliaMeterRegistry(gangliaConfig, clock, nameMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

