/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.graphite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.export.graphite.GraphiteProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.graphite.GraphitePropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GraphiteMeterRegistry.class})
@EnableConfigurationProperties(value={GraphiteProperties.class})
public class GraphiteExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphiteConfig graphiteConfig(GraphiteProperties graphiteProperties) {
        return new GraphitePropertiesConfigAdapter(graphiteProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.export.graphite.enabled"}, matchIfMissing=true)
    public GraphiteMeterRegistry graphiteMeterRegistry(GraphiteConfig graphiteConfig, HierarchicalNameMapper nameMapper, Clock clock) {
        return new GraphiteMeterRegistry(graphiteConfig, clock, nameMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

