/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.web.client;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.metrics.web.client.DefaultRestTemplateExchangeTagsProvider;
import org.springframework.boot.actuate.metrics.web.client.MetricsRestTemplateCustomizer;
import org.springframework.boot.actuate.metrics.web.client.RestTemplateExchangeTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
public class RestTemplateMetricsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RestTemplateExchangeTagsProvider.class})
    public DefaultRestTemplateExchangeTagsProvider restTemplateTagConfigurer() {
        return new DefaultRestTemplateExchangeTagsProvider();
    }

    @Bean
    public MetricsRestTemplateCustomizer metricsRestTemplateCustomizer(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider restTemplateTagConfigurer, MetricsProperties properties) {
        return new MetricsRestTemplateCustomizer(meterRegistry, restTemplateTagConfigurer, properties.getWeb().getClient().getRequestsMetricName(), properties.getWeb().getClient().isRecordRequestPercentiles());
    }

    @Bean
    @Order(value=0)
    public MeterFilter metricsWebClientUriTagFilter(MetricsProperties properties) {
        String metricName = properties.getWeb().getClient().getRequestsMetricName();
        MaximumUriTagsReachedMeterFilter denyFilter = new MaximumUriTagsReachedMeterFilter(metricName);
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)properties.getWeb().getClient().getMaxUriTags(), (MeterFilter)denyFilter);
    }

    private static class MaximumUriTagsReachedMeterFilter
    implements MeterFilter {
        private final Logger logger = LoggerFactory.getLogger(RestTemplateMetricsConfiguration.class);
        private final String metricName;
        private final AtomicBoolean alreadyWarned = new AtomicBoolean(false);

        MaximumUriTagsReachedMeterFilter(String metricName) {
            this.metricName = metricName;
        }

        public MeterFilterReply accept(Meter.Id id) {
            if (this.alreadyWarned.compareAndSet(false, true)) {
                this.logWarning();
            }
            return MeterFilterReply.DENY;
        }

        private void logWarning() {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Reached the maximum number of URI tags for '" + this.metricName + "'. Are you using uriVariables on RestTemplate calls?");
            }
        }
    }
}

