/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cassandra;

import com.datastax.driver.core.Cluster;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.cassandra.CassandraHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.cassandra.CassandraDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.core.CassandraOperations;

@Configuration
@ConditionalOnClass(value={CassandraOperations.class, Cluster.class})
@ConditionalOnBean(value={CassandraOperations.class})
@ConditionalOnEnabledHealthIndicator(value="cassandra")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={CassandraAutoConfiguration.class, CassandraDataAutoConfiguration.class})
public class CassandraHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<CassandraHealthIndicator, CassandraOperations> {
    private final Map<String, CassandraOperations> cassandraOperations;

    public CassandraHealthIndicatorAutoConfiguration(Map<String, CassandraOperations> cassandraOperations) {
        this.cassandraOperations = cassandraOperations;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cassandraHealthIndicator"})
    public HealthIndicator cassandraHealthIndicator() {
        return this.createHealthIndicator(this.cassandraOperations);
    }
}

