/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.jms;

import java.util.Map;
import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.jms.JmsHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ConnectionFactory.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="jms")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={ActiveMQAutoConfiguration.class, ArtemisAutoConfiguration.class})
public class JmsHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<JmsHealthIndicator, ConnectionFactory> {
    private final Map<String, ConnectionFactory> connectionFactories;

    public JmsHealthIndicatorAutoConfiguration(ObjectProvider<Map<String, ConnectionFactory>> connectionFactories) {
        this.connectionFactories = (Map)connectionFactories.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(name={"jmsHealthIndicator"})
    public HealthIndicator jmsHealthIndicator() {
        return this.createHealthIndicator(this.connectionFactories);
    }
}

