/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusPushGatewayManager;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogMessage;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.prometheus", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusProperties.class})
public class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PrometheusConfig prometheusConfig(PrometheusProperties prometheusProperties) {
        return new PrometheusPropertiesConfigAdapter(prometheusProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig prometheusConfig, CollectorRegistry collectorRegistry, Clock clock) {
        return new PrometheusMeterRegistry(prometheusConfig, collectorRegistry, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={PushGateway.class})
    @ConditionalOnProperty(prefix="management.metrics.export.prometheus.pushgateway", name={"enabled"})
    public static class PrometheusPushGatewayConfiguration {
        private static final Log logger = LogFactory.getLog(PrometheusPushGatewayConfiguration.class);
        private static final String FALLBACK_JOB = "spring";

        @Bean
        @ConditionalOnMissingBean
        public PrometheusPushGatewayManager prometheusPushGatewayManager(CollectorRegistry collectorRegistry, PrometheusProperties prometheusProperties, Environment environment) {
            PrometheusProperties.Pushgateway properties = prometheusProperties.getPushgateway();
            Duration pushRate = properties.getPushRate();
            String job = this.getJob(properties, environment);
            Map<String, String> groupingKey = properties.getGroupingKey();
            PrometheusPushGatewayManager.ShutdownOperation shutdownOperation = properties.getShutdownOperation();
            return new PrometheusPushGatewayManager(this.getPushGateway(properties.getBaseUrl()), collectorRegistry, pushRate, job, groupingKey, shutdownOperation);
        }

        private PushGateway getPushGateway(String url) {
            try {
                return new PushGateway(new URL(url));
            }
            catch (MalformedURLException ex) {
                logger.warn((Object)LogMessage.format((String)"Invalid PushGateway base url '%s': update your configuration to a valid URL", (Object)url));
                return new PushGateway(url);
            }
        }

        private String getJob(PrometheusProperties.Pushgateway properties, Environment environment) {
            String job = properties.getJob();
            job = job != null ? job : environment.getProperty("spring.application.name");
            return job != null ? job : FALLBACK_JOB;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnAvailableEndpoint(endpoint=PrometheusScrapeEndpoint.class)
    public static class PrometheusScrapeEndpointConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusScrapeEndpoint(collectorRegistry);
        }
    }
}

