/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.data;

import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.metrics.data.MetricsRepositoryMethodInvocationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactoryCustomizer;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;

class MetricsRepositoryMethodInvocationListenerBeanPostProcessor
implements BeanPostProcessor {
    private final RepositoryFactoryCustomizer customizer;

    MetricsRepositoryMethodInvocationListenerBeanPostProcessor(Supplier<MetricsRepositoryMethodInvocationListener> listener) {
        this.customizer = new MetricsRepositoryFactoryCustomizer(listener);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RepositoryFactoryBeanSupport) {
            ((RepositoryFactoryBeanSupport)bean).addRepositoryFactoryCustomizer(this.customizer);
        }
        return bean;
    }

    private static final class MetricsRepositoryFactoryCustomizer
    implements RepositoryFactoryCustomizer {
        private final Supplier<MetricsRepositoryMethodInvocationListener> listenerSupplier;
        private volatile MetricsRepositoryMethodInvocationListener listener;

        private MetricsRepositoryFactoryCustomizer(Supplier<MetricsRepositoryMethodInvocationListener> listenerSupplier) {
            this.listenerSupplier = listenerSupplier;
        }

        public void customize(RepositoryFactorySupport repositoryFactory) {
            if (this.listener == null) {
                this.listener = this.listenerSupplier.get();
            }
            repositoryFactory.addInvocationListener((RepositoryMethodInvocationListener)this.listener);
        }
    }
}

