/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.LazyInitializationBeanFactoryPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableChildManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={WebEndpointProperties.class, ManagementServerProperties.class})
public class ManagementContextAutoConfiguration {

    private static class CloseManagementContextListener
    implements ApplicationListener<ApplicationEvent> {
        private final ApplicationContext parentContext;
        private final ConfigurableApplicationContext childContext;

        CloseManagementContextListener(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            this.parentContext = parentContext;
            this.childContext = childContext;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ContextClosedEvent) {
                this.onContextClosedEvent((ContextClosedEvent)event);
            }
            if (event instanceof ApplicationFailedEvent) {
                this.onApplicationFailedEvent((ApplicationFailedEvent)event);
            }
        }

        private void onContextClosedEvent(ContextClosedEvent event) {
            this.propagateCloseIfNecessary(event.getApplicationContext());
        }

        private void onApplicationFailedEvent(ApplicationFailedEvent event) {
            this.propagateCloseIfNecessary((ApplicationContext)event.getApplicationContext());
        }

        private void propagateCloseIfNecessary(ApplicationContext applicationContext) {
            if (applicationContext == this.parentContext) {
                this.childContext.close();
            }
        }

        static void addIfPossible(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            if (parentContext instanceof ConfigurableApplicationContext) {
                CloseManagementContextListener.add((ConfigurableApplicationContext)parentContext, childContext);
            }
        }

        private static void add(ConfigurableApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            parentContext.addApplicationListener((ApplicationListener)new CloseManagementContextListener((ApplicationContext)parentContext, childContext));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    static class DifferentManagementContextConfiguration
    implements ApplicationListener<WebServerInitializedEvent> {
        private final ApplicationContext applicationContext;
        private final ManagementContextFactory managementContextFactory;

        DifferentManagementContextConfiguration(ApplicationContext applicationContext, ManagementContextFactory managementContextFactory) {
            this.applicationContext = applicationContext;
            this.managementContextFactory = managementContextFactory;
        }

        public void onApplicationEvent(WebServerInitializedEvent event) {
            if (event.getApplicationContext().equals(this.applicationContext)) {
                ConfigurableWebServerApplicationContext managementContext = this.managementContextFactory.createManagementContext(this.applicationContext, EnableChildManagementContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class);
                if (this.isLazyInitialization()) {
                    managementContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new LazyInitializationBeanFactoryPostProcessor());
                }
                managementContext.setServerNamespace("management");
                managementContext.setId(this.applicationContext.getId() + ":management");
                this.setClassLoaderIfPossible((ConfigurableApplicationContext)managementContext);
                CloseManagementContextListener.addIfPossible(this.applicationContext, (ConfigurableApplicationContext)managementContext);
                managementContext.refresh();
            }
        }

        protected boolean isLazyInitialization() {
            AbstractApplicationContext context = (AbstractApplicationContext)this.applicationContext;
            List postProcessors = context.getBeanFactoryPostProcessors();
            return postProcessors.stream().anyMatch(LazyInitializationBeanFactoryPostProcessor.class::isInstance);
        }

        private void setClassLoaderIfPossible(ConfigurableApplicationContext child) {
            if (child instanceof DefaultResourceLoader) {
                ((DefaultResourceLoader)child).setClassLoader(this.applicationContext.getClassLoader());
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnManagementPort(value=ManagementPortType.SAME)
    static class SameManagementContextConfiguration
    implements SmartInitializingSingleton {
        private final Environment environment;

        SameManagementContextConfiguration(Environment environment) {
            this.environment = environment;
        }

        public void afterSingletonsInstantiated() {
            this.verifySslConfiguration();
            this.verifyAddressConfiguration();
            if (this.environment instanceof ConfigurableEnvironment) {
                this.addLocalManagementPortPropertyAlias((ConfigurableEnvironment)this.environment);
            }
        }

        private void verifySslConfiguration() {
            Boolean enabled = (Boolean)this.environment.getProperty("management.server.ssl.enabled", Boolean.class, (Object)false);
            Assert.state((enabled == false ? 1 : 0) != 0, (String)"Management-specific SSL cannot be configured as the management server is not listening on a separate port");
        }

        private void verifyAddressConfiguration() {
            String address = this.environment.getProperty("management.server.address");
            Assert.state((address == null ? 1 : 0) != 0, (String)"Management-specific server address cannot be configured as the management server is not listening on a separate port");
        }

        private void addLocalManagementPortPropertyAlias(final ConfigurableEnvironment environment) {
            environment.getPropertySources().addLast((PropertySource)new PropertySource<Object>("Management Server"){

                public Object getProperty(String name) {
                    if ("local.management.port".equals(name)) {
                        return environment.getProperty("local.server.port");
                    }
                    return null;
                }
            });
        }

        @Configuration(proxyBeanMethods=false)
        @EnableManagementContext(value=ManagementContextType.SAME)
        static class EnableSameManagementContextConfiguration {
            EnableSameManagementContextConfiguration() {
            }
        }
    }
}

