/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.quartz;

import org.quartz.Scheduler;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.quartz.QuartzEndpoint;
import org.springframework.boot.actuate.quartz.QuartzEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Scheduler.class})
@AutoConfigureAfter(value={QuartzAutoConfiguration.class})
@ConditionalOnAvailableEndpoint(endpoint=QuartzEndpoint.class)
public class QuartzEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Scheduler.class})
    @ConditionalOnMissingBean
    public QuartzEndpoint quartzEndpoint(Scheduler scheduler) {
        return new QuartzEndpoint(scheduler);
    }

    @Bean
    @ConditionalOnBean(value={QuartzEndpoint.class})
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB, EndpointExposure.CLOUD_FOUNDRY})
    public QuartzEndpointWebExtension quartzEndpointWebExtension(QuartzEndpoint endpoint) {
        return new QuartzEndpointWebExtension(endpoint);
    }
}

