/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.expose;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class IncludeExcludeEndpointFilter<E extends ExposableEndpoint<?>>
implements EndpointFilter<E> {
    private final Class<E> endpointType;
    private final EndpointPatterns include;
    private final EndpointPatterns defaultIncludes;
    private final EndpointPatterns exclude;

    @Deprecated
    public IncludeExcludeEndpointFilter(Class<E> endpointType, Environment environment, String prefix, DefaultIncludes defaultIncludes) {
        this(endpointType, environment, prefix, DefaultIncludes.patterns(defaultIncludes));
    }

    public IncludeExcludeEndpointFilter(Class<E> endpointType, Environment environment, String prefix, String ... defaultIncludes) {
        this(endpointType, environment, prefix, new EndpointPatterns(defaultIncludes));
    }

    public IncludeExcludeEndpointFilter(Class<E> endpointType, Collection<String> include, Collection<String> exclude, String ... defaultIncludes) {
        this(endpointType, include, exclude, new EndpointPatterns(defaultIncludes));
    }

    @Deprecated
    public IncludeExcludeEndpointFilter(Class<E> endpointType, Collection<String> include, Collection<String> exclude, DefaultIncludes defaultIncludes) {
        this(endpointType, include, exclude, DefaultIncludes.patterns(defaultIncludes));
    }

    private IncludeExcludeEndpointFilter(Class<E> endpointType, Environment environment, String prefix, EndpointPatterns defaultIncludes) {
        Assert.notNull(endpointType, (String)"EndpointType must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty");
        Assert.notNull((Object)defaultIncludes, (String)"DefaultIncludes must not be null");
        Binder binder = Binder.get((Environment)environment);
        this.endpointType = endpointType;
        this.include = new EndpointPatterns(this.bind(binder, prefix + ".include"));
        this.defaultIncludes = defaultIncludes;
        this.exclude = new EndpointPatterns(this.bind(binder, prefix + ".exclude"));
    }

    private IncludeExcludeEndpointFilter(Class<E> endpointType, Collection<String> include, Collection<String> exclude, EndpointPatterns defaultIncludes) {
        Assert.notNull(endpointType, (String)"EndpointType Type must not be null");
        Assert.notNull((Object)defaultIncludes, (String)"DefaultIncludes must not be null");
        this.endpointType = endpointType;
        this.include = new EndpointPatterns(include);
        this.defaultIncludes = defaultIncludes;
        this.exclude = new EndpointPatterns(exclude);
    }

    private List<String> bind(Binder binder, String name) {
        return (List)binder.bind(name, Bindable.listOf(String.class)).orElseGet(ArrayList::new);
    }

    public boolean match(E endpoint) {
        if (!this.endpointType.isInstance(endpoint)) {
            return true;
        }
        return this.match(endpoint.getEndpointId());
    }

    public final boolean match(EndpointId endpointId) {
        return this.isIncluded(endpointId) && !this.isExcluded(endpointId);
    }

    private boolean isIncluded(EndpointId endpointId) {
        if (this.include.isEmpty()) {
            return this.defaultIncludes.matches(endpointId);
        }
        return this.include.matches(endpointId);
    }

    private boolean isExcluded(EndpointId endpointId) {
        if (this.exclude.isEmpty()) {
            return false;
        }
        return this.exclude.matches(endpointId);
    }

    private static class EndpointPatterns {
        private final boolean empty;
        private final boolean matchesAll;
        private final Set<EndpointId> endpointIds;

        EndpointPatterns(String[] patterns) {
            this(patterns != null ? Arrays.asList(patterns) : (Collection)null);
        }

        EndpointPatterns(Collection<String> patterns) {
            patterns = patterns != null ? patterns : Collections.emptySet();
            boolean matchesAll = false;
            LinkedHashSet<EndpointId> endpointIds = new LinkedHashSet<EndpointId>();
            for (String pattern : patterns) {
                if ("*".equals(pattern)) {
                    matchesAll = true;
                    continue;
                }
                endpointIds.add(EndpointId.fromPropertyValue((String)pattern));
            }
            this.empty = patterns.isEmpty();
            this.matchesAll = matchesAll;
            this.endpointIds = endpointIds;
        }

        boolean isEmpty() {
            return this.empty;
        }

        boolean matches(EndpointId endpointId) {
            return this.matchesAll || this.endpointIds.contains(endpointId);
        }

        static EndpointPatterns forExposure(EndpointExposure exposure) {
            return exposure != null ? new EndpointPatterns(exposure.getDefaultIncludes()) : null;
        }
    }

    @Deprecated
    public static enum DefaultIncludes {
        JMX("*"),
        WEB("health");

        private final EndpointPatterns patterns;

        private DefaultIncludes(String ... patterns) {
            this.patterns = new EndpointPatterns(patterns);
        }

        static EndpointPatterns patterns(DefaultIncludes defaultIncludes) {
            return defaultIncludes != null ? defaultIncludes.patterns : (EndpointPatterns)null;
        }
    }
}

