/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthContributorRegistry;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthEndpointGroups;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.CompositeReactiveHealthContributor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointGroupsPostProcessor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration(proxyBeanMethods=false)
class HealthEndpointConfiguration {
    HealthEndpointConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    StatusAggregator healthStatusAggregator(HealthEndpointProperties properties) {
        return new SimpleStatusAggregator(properties.getStatus().getOrder());
    }

    @Bean
    @ConditionalOnMissingBean
    HttpCodeStatusMapper healthHttpCodeStatusMapper(HealthEndpointProperties properties) {
        return new SimpleHttpCodeStatusMapper(properties.getStatus().getHttpMapping());
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpointGroups healthEndpointGroups(ApplicationContext applicationContext, HealthEndpointProperties properties) {
        return new AutoConfiguredHealthEndpointGroups(applicationContext, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    HealthContributorRegistry healthContributorRegistry(ApplicationContext applicationContext, HealthEndpointGroups groups) {
        LinkedHashMap<String, HealthContributor> healthContributors = new LinkedHashMap<String, HealthContributor>(applicationContext.getBeansOfType(HealthContributor.class));
        if (ClassUtils.isPresent((String)"reactor.core.publisher.Flux", (ClassLoader)applicationContext.getClassLoader())) {
            healthContributors.putAll(new AdaptedReactiveHealthContributors(applicationContext).get());
        }
        return new AutoConfiguredHealthContributorRegistry(healthContributors, groups.getNames());
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpoint healthEndpoint(HealthContributorRegistry registry, HealthEndpointGroups groups, HealthEndpointProperties properties) {
        return new HealthEndpoint(registry, groups, properties.getLogging().getSlowIndicatorThreshold());
    }

    @Bean
    static HealthEndpointGroupsBeanPostProcessor healthEndpointGroupsBeanPostProcessor(ObjectProvider<HealthEndpointGroupsPostProcessor> healthEndpointGroupsPostProcessors) {
        return new HealthEndpointGroupsBeanPostProcessor(healthEndpointGroupsPostProcessors);
    }

    private static class AdaptedReactiveHealthContributors {
        private final Map<String, HealthContributor> adapted;

        AdaptedReactiveHealthContributors(ApplicationContext applicationContext) {
            LinkedHashMap adapted = new LinkedHashMap();
            applicationContext.getBeansOfType(ReactiveHealthContributor.class).forEach((name, contributor) -> adapted.put(name, this.adapt((ReactiveHealthContributor)contributor)));
            this.adapted = Collections.unmodifiableMap(adapted);
        }

        private HealthContributor adapt(ReactiveHealthContributor contributor) {
            if (contributor instanceof ReactiveHealthIndicator) {
                return this.adapt((ReactiveHealthIndicator)contributor);
            }
            if (contributor instanceof CompositeReactiveHealthContributor) {
                return this.adapt((CompositeReactiveHealthContributor)contributor);
            }
            throw new IllegalStateException("Unsupported ReactiveHealthContributor type " + contributor.getClass());
        }

        private HealthIndicator adapt(final ReactiveHealthIndicator indicator) {
            return new HealthIndicator(){

                public Health getHealth(boolean includeDetails) {
                    return (Health)indicator.getHealth(includeDetails).block();
                }

                public Health health() {
                    return (Health)indicator.health().block();
                }
            };
        }

        private CompositeHealthContributor adapt(final CompositeReactiveHealthContributor composite) {
            return new CompositeHealthContributor(){

                public Iterator<NamedContributor<HealthContributor>> iterator() {
                    final Iterator iterator = composite.iterator();
                    return new Iterator<NamedContributor<HealthContributor>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public NamedContributor<HealthContributor> next() {
                            NamedContributor next = (NamedContributor)iterator.next();
                            return NamedContributor.of((String)next.getName(), (Object)this.adapt((ReactiveHealthContributor)next.getContributor()));
                        }
                    };
                }

                public HealthContributor getContributor(String name) {
                    return this.adapt((ReactiveHealthContributor)composite.getContributor(name));
                }
            };
        }

        Map<String, HealthContributor> get() {
            return this.adapted;
        }
    }

    static class HealthEndpointGroupsBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<HealthEndpointGroupsPostProcessor> postProcessors;

        HealthEndpointGroupsBeanPostProcessor(ObjectProvider<HealthEndpointGroupsPostProcessor> postProcessors) {
            this.postProcessors = postProcessors;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof HealthEndpointGroups) {
                return this.applyPostProcessors((HealthEndpointGroups)bean);
            }
            return bean;
        }

        private Object applyPostProcessors(HealthEndpointGroups bean) {
            for (HealthEndpointGroupsPostProcessor postProcessor : (HealthEndpointGroupsPostProcessor[])this.postProcessors.orderedStream().toArray(HealthEndpointGroupsPostProcessor[]::new)) {
                bean = postProcessor.postProcessHealthEndpointGroups(bean);
            }
            return bean;
        }
    }
}

