/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.web.client.ClientHttpObservationConventionAdapter;
import org.springframework.boot.actuate.metrics.web.client.ObservationRestTemplateCustomizer;
import org.springframework.boot.actuate.metrics.web.client.RestTemplateExchangeTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.http.client.observation.DefaultClientRequestObservationConvention;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={RestTemplateBuilder.class})
class RestTemplateObservationConfiguration {
    RestTemplateObservationConfiguration() {
    }

    @Bean
    ObservationRestTemplateCustomizer observationRestTemplateCustomizer(ObservationRegistry observationRegistry, ObservationProperties observationProperties, MetricsProperties metricsProperties, ObjectProvider<RestTemplateExchangeTagsProvider> optionalTagsProvider) {
        String metricName = metricsProperties.getWeb().getClient().getRequest().getMetricName();
        String observationName = observationProperties.getHttp().getClient().getRequests().getName();
        String name = observationName != null ? observationName : metricName;
        RestTemplateExchangeTagsProvider tagsProvider = (RestTemplateExchangeTagsProvider)optionalTagsProvider.getIfAvailable();
        ClientHttpObservationConventionAdapter observationConvention = tagsProvider != null ? new ClientHttpObservationConventionAdapter(name, tagsProvider) : new DefaultClientRequestObservationConvention(name);
        return new ObservationRestTemplateCustomizer(observationRegistry, (ClientRequestObservationConvention)observationConvention);
    }
}

