/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.web.client.ClientObservationConventionAdapter;
import org.springframework.boot.actuate.metrics.web.reactive.client.ObservationWebClientCustomizer;
import org.springframework.boot.actuate.metrics.web.reactive.client.WebClientExchangeTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.DefaultClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
class WebClientObservationConfiguration {
    WebClientObservationConfiguration() {
    }

    @Bean
    ObservationWebClientCustomizer observationWebClientCustomizer(ObservationRegistry observationRegistry, ObservationProperties observationProperties, ObjectProvider<WebClientExchangeTagsProvider> optionalTagsProvider, MetricsProperties metricsProperties) {
        String metricName = metricsProperties.getWeb().getClient().getRequest().getMetricName();
        String observationName = observationProperties.getHttp().getClient().getRequests().getName();
        String name = observationName != null ? observationName : metricName;
        WebClientExchangeTagsProvider tagsProvider = (WebClientExchangeTagsProvider)optionalTagsProvider.getIfAvailable();
        ClientObservationConventionAdapter observationConvention = tagsProvider != null ? new ClientObservationConventionAdapter(name, tagsProvider) : new DefaultClientRequestObservationConvention(name);
        return new ObservationWebClientCustomizer(observationRegistry, (ClientRequestObservationConvention)observationConvention);
    }
}

