/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.reactive;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.web.reactive.ServerRequestObservationConventionAdapter;
import org.springframework.boot.actuate.metrics.web.reactive.server.WebFluxTagsContributor;
import org.springframework.boot.actuate.metrics.web.reactive.server.WebFluxTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;
import org.springframework.web.filter.reactive.ServerHttpObservationFilter;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnClass(value={Observation.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public class WebFluxObservationAutoConfiguration {
    private final MetricsProperties metricsProperties;
    private final ObservationProperties observationProperties;

    public WebFluxObservationAutoConfiguration(MetricsProperties metricsProperties, ObservationProperties observationProperties) {
        this.metricsProperties = metricsProperties;
        this.observationProperties = observationProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=-2147483647)
    public ServerHttpObservationFilter webfluxObservationFilter(ObservationRegistry registry, ObjectProvider<ServerRequestObservationConvention> customConvention, ObjectProvider<WebFluxTagsProvider> tagConfigurer, ObjectProvider<WebFluxTagsContributor> contributorsProvider) {
        String observationName = this.observationProperties.getHttp().getServer().getRequests().getName();
        String metricName = this.metricsProperties.getWeb().getServer().getRequest().getMetricName();
        String name = observationName != null ? observationName : metricName;
        WebFluxTagsProvider tagsProvider = (WebFluxTagsProvider)tagConfigurer.getIfAvailable();
        List<WebFluxTagsContributor> tagsContributors = contributorsProvider.orderedStream().toList();
        ServerRequestObservationConvention convention = WebFluxObservationAutoConfiguration.createConvention((ServerRequestObservationConvention)customConvention.getIfAvailable(), name, tagsProvider, tagsContributors);
        return new ServerHttpObservationFilter(registry, convention);
    }

    private static ServerRequestObservationConvention createConvention(ServerRequestObservationConvention customConvention, String name, WebFluxTagsProvider tagsProvider, List<WebFluxTagsContributor> tagsContributors) {
        if (customConvention != null) {
            return customConvention;
        }
        if (tagsProvider != null) {
            return new ServerRequestObservationConventionAdapter(name, tagsProvider);
        }
        if (!tagsContributors.isEmpty()) {
            return new ServerRequestObservationConventionAdapter(name, tagsContributors);
        }
        return new DefaultServerRequestObservationConvention(name);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    static class MeterFilterConfiguration {
        MeterFilterConfiguration() {
        }

        @Bean
        @Order(value=0)
        MeterFilter metricsHttpServerUriTagFilter(MetricsProperties metricsProperties, ObservationProperties observationProperties) {
            String observationName = observationProperties.getHttp().getServer().getRequests().getName();
            String name = observationName != null ? observationName : metricsProperties.getWeb().getServer().getRequest().getMetricName();
            OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> "Reached the maximum number of URI tags for '%s'.".formatted(name));
            return MeterFilter.maximumAllowableTags((String)name, (String)"uri", (int)metricsProperties.getWeb().getServer().getMaxUriTags(), (MeterFilter)filter);
        }
    }
}

