/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.graphql;

import graphql.GraphQL;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.propagation.Propagator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.observation.DataFetcherObservationConvention;
import org.springframework.graphql.observation.ExecutionRequestObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationInstrumentation;
import org.springframework.graphql.observation.PropagationWebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlHandler;

@AutoConfiguration(after={ObservationAutoConfiguration.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class, Observation.class})
public class GraphQlObservationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphQlObservationInstrumentation graphQlObservationInstrumentation(ObservationRegistry observationRegistry, ObjectProvider<ExecutionRequestObservationConvention> executionConvention, ObjectProvider<DataFetcherObservationConvention> dataFetcherConvention) {
        return new GraphQlObservationInstrumentation(observationRegistry, (ExecutionRequestObservationConvention)executionConvention.getIfAvailable(), (DataFetcherObservationConvention)dataFetcherConvention.getIfAvailable());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Propagator.class})
    @ConditionalOnBean(value={WebGraphQlHandler.class})
    static class TracingObservationConfiguration {
        TracingObservationConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={Propagator.class})
        @ConditionalOnMissingBean
        @Order(value=-2147483647)
        PropagationWebGraphQlInterceptor propagationWebGraphQlInterceptor(Propagator propagator) {
            return new PropagationWebGraphQlInterceptor(propagator);
        }
    }
}

